/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.util.List;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.Toggle;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.internal.ui.palette.PaletteColorUtil;
import org.eclipse.gef.internal.ui.palette.editparts.ColumnsLayout;
import org.eclipse.gef.internal.ui.palette.editparts.EditPartTipHelper;
import org.eclipse.gef.internal.ui.palette.editparts.OverlayScrollPaneLayout;
import org.eclipse.gef.internal.ui.palette.editparts.PaletteContainerFlowLayout;
import org.eclipse.gef.internal.ui.palette.editparts.PaletteScrollBar;
import org.eclipse.gef.internal.ui.palette.editparts.PinFigure;
import org.eclipse.gef.internal.ui.palette.editparts.PinnablePaletteStackFigure;
import org.eclipse.gef.internal.ui.palette.editparts.RaisedBorder;
import org.eclipse.gef.ui.palette.editparts.PaletteToolbarLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DrawerFigure
extends Figure {
    protected static final Color FG_COLOR = FigureUtilities.mixColors((Color)PaletteColorUtil.WIDGET_NORMAL_SHADOW, (Color)PaletteColorUtil.WIDGET_BACKGROUND);
    protected static final Border SCROLL_PANE_BORDER = new MarginBorder(2, 2, 2, 2);
    protected static final Border SCROLL_PANE_LIST_BORDER = new MarginBorder(2, 0, 2, 0);
    protected static final Border TITLE_MARGIN_BORDER = new MarginBorder(4, 2, 2, 2);
    protected static final Border TOGGLE_BUTTON_BORDER = new RaisedBorder();
    protected static final Border TOOLTIP_BORDER = new CompoundBorder((Border)new SchemeBorder(SchemeBorder.SCHEMES.RAISED), (Border)new MarginBorder(1));
    private Toggle collapseToggle;
    private Label drawerLabel;
    private Label tipLabel;
    private boolean addedScrollpane = false;
    private int layoutMode = -1;
    private PinFigure pinFigure;
    private ScrollPane scrollpane;
    private boolean showPin = true;
    private boolean skipNextEvent;
    private EditPartTipHelper tipHelper;

    public DrawerFigure(Control control) {
        this.setLayoutManager((LayoutManager)new PaletteToolbarLayout(){

            @Override
            protected boolean isChildGrowing(IFigure child) {
                int wHint = child.getBounds().width;
                return child.getPreferredSize((int)wHint, (int)-1).height != child.getMinimumSize((int)wHint, (int)-1).height;
            }
        });
        Figure title = new Figure();
        title.setBorder(TITLE_MARGIN_BORDER);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHorizontalSpacing(2);
        title.setLayoutManager((LayoutManager)borderLayout);
        this.drawerLabel = new Label();
        this.drawerLabel.setLabelAlignment(1);
        this.pinFigure = new PinFigure();
        title.add((IFigure)this.pinFigure, (Object)BorderLayout.RIGHT);
        title.add((IFigure)this.drawerLabel, (Object)BorderLayout.CENTER);
        this.collapseToggle = new CollapseToggle((IFigure)title);
        this.add((IFigure)this.collapseToggle);
        this.createScrollpane();
        this.createHoverHelp(control);
    }

    private void paintToggleGradient(Graphics g, Rectangle rect) {
        if (this.isExpanded()) {
            g.setBackgroundColor(PaletteColorUtil.WIDGET_BACKGROUND_LIST_BACKGROUND_85);
            g.fillRectangle(rect);
        } else if (this.collapseToggle.getModel().isMouseOver()) {
            Color color1 = PaletteColorUtil.WIDGET_BACKGROUND_LIST_BACKGROUND_60;
            Color color2 = PaletteColorUtil.WIDGET_BACKGROUND_NORMAL_SHADOW_90;
            Color color3 = PaletteColorUtil.WIDGET_BACKGROUND_NORMAL_SHADOW_95;
            Color color4 = PaletteColorUtil.WIDGET_BACKGROUND_LIST_BACKGROUND_90;
            g.setForegroundColor(color1);
            g.setBackgroundColor(color2);
            g.fillGradient(rect.x, rect.y, rect.width, rect.height - 4, true);
            g.setForegroundColor(color2);
            g.setBackgroundColor(color3);
            g.fillGradient(rect.x, rect.bottom() - 4, rect.width, 2, true);
            g.setForegroundColor(color3);
            g.setBackgroundColor(color4);
            g.fillGradient(rect.x, rect.bottom() - 2, rect.width, 2, true);
        } else {
            g.setForegroundColor(PaletteColorUtil.WIDGET_BACKGROUND_LIST_BACKGROUND_85);
            g.setBackgroundColor(PaletteColorUtil.WIDGET_BACKGROUND_NORMAL_SHADOW_45);
            g.fillGradient(rect, true);
        }
    }

    private void createHoverHelp(final Control control) {
        if (control == null) {
            return;
        }
        this.tipLabel = new Label(){

            public IFigure getToolTip() {
                return DrawerFigure.this.buildTooltip();
            }

            protected void paintFigure(Graphics graphics) {
                Rectangle r = Rectangle.SINGLETON;
                r.setBounds(this.getBounds());
                graphics.pushState();
                DrawerFigure.this.paintToggleGradient(graphics, this.getBounds());
                graphics.popState();
                super.paintFigure(graphics);
            }
        };
        this.tipLabel.setOpaque(false);
        this.tipLabel.setBorder(TOOLTIP_BORDER);
        this.collapseToggle.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseMoved(MouseEvent e) {
                if (!DrawerFigure.this.drawerLabel.getBounds().contains(e.getLocation())) {
                    return;
                }
                if (DrawerFigure.this.skipNextEvent) {
                    DrawerFigure.this.skipNextEvent = false;
                    return;
                }
                if (DrawerFigure.this.drawerLabel.isTextTruncated() && !EditPartTipHelper.isCurrent(DrawerFigure.this.tipHelper)) {
                    DrawerFigure.this.tipLabel.setText(DrawerFigure.this.drawerLabel.getText());
                    DrawerFigure.this.tipLabel.setIcon(DrawerFigure.this.drawerLabel.getIcon());
                    DrawerFigure.this.tipLabel.setFont(DrawerFigure.this.drawerLabel.getFont());
                    DrawerFigure.this.tipHelper = new EditPartTipHelper(control);
                    Rectangle bounds = DrawerFigure.this.drawerLabel.getBounds().getExpanded(2, 2);
                    DrawerFigure.this.drawerLabel.translateToAbsolute((Translatable)bounds);
                    org.eclipse.swt.graphics.Rectangle loc = new org.eclipse.swt.graphics.Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                    loc = Display.getCurrent().map(control, null, loc);
                    DrawerFigure.this.tipHelper.displayToolTipAt((IFigure)DrawerFigure.this.tipLabel, loc.x, loc.y);
                }
            }
        });
        this.tipLabel.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent e) {
                if (e.button == 1) {
                    Rectangle original = DrawerFigure.this.getCollapseToggle().getBounds().getCopy();
                    DrawerFigure.this.getCollapseToggle().requestFocus();
                    DrawerFigure.this.setExpanded(!DrawerFigure.this.isExpanded());
                    if (!original.equals((Object)DrawerFigure.this.getCollapseToggle().getBounds())) {
                        DrawerFigure.this.tipHelper.hide();
                    }
                } else {
                    DrawerFigure.this.tipHelper.hide();
                    if (e.button == 3) {
                        DrawerFigure.this.skipNextEvent = true;
                    }
                }
            }
        });
    }

    private void createScrollpane() {
        this.scrollpane = new ScrollPane();
        this.scrollpane.getViewport().setContentsTracksWidth(true);
        this.scrollpane.setMinimumSize(new Dimension(0, 0));
        this.scrollpane.setHorizontalScrollBarVisibility(0);
        this.scrollpane.setVerticalScrollBar((ScrollBar)new PaletteScrollBar());
        this.scrollpane.getVerticalScrollBar().setStepIncrement(20);
        this.scrollpane.setLayoutManager((LayoutManager)new OverlayScrollPaneLayout());
        this.scrollpane.setContents((IFigure)new Figure());
        this.scrollpane.getContents().setOpaque(true);
        this.scrollpane.getContents().setBackgroundColor(PaletteColorUtil.WIDGET_LIST_BACKGROUND);
    }

    IFigure buildTooltip() {
        return null;
    }

    public Clickable getCollapseToggle() {
        return this.collapseToggle;
    }

    public IFigure getContentPane() {
        return this.scrollpane.getContents();
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        List children;
        if (this.isExpanded() && !(children = this.getContentPane().getChildren()).isEmpty()) {
            Dimension result = this.collapseToggle.getPreferredSize(wHint, hHint).getCopy();
            result.height += this.getContentPane().getInsets().getHeight();
            IFigure child = (IFigure)children.get(0);
            result.height += Math.min(80, child.getPreferredSize((int)wHint, (int)-1).height + 9);
            return result.intersect(this.getPreferredSize(wHint, hHint));
        }
        return super.getMinimumSize(wHint, hHint);
    }

    public ScrollPane getScrollpane() {
        return this.scrollpane;
    }

    protected void handleExpandStateChanged() {
        if (this.isExpanded()) {
            if (this.scrollpane.getParent() != this) {
                this.add((IFigure)this.scrollpane);
            }
        } else {
            if (this.scrollpane.getParent() == this) {
                this.remove((IFigure)this.scrollpane);
            }
            for (Object child : this.getContentPane().getChildren()) {
                if (!(child instanceof PinnablePaletteStackFigure) || ((PinnablePaletteStackFigure)((Object)child)).isPinnedOpen()) continue;
                ((PinnablePaletteStackFigure)((Object)child)).setExpanded(false);
            }
        }
        if (this.pinFigure != null) {
            this.pinFigure.setVisible(this.isExpanded() && this.showPin);
        }
    }

    public boolean isExpanded() {
        return this.collapseToggle.isSelected();
    }

    public boolean isPinnedOpen() {
        return this.isExpanded() && this.pinFigure.isVisible() && this.pinFigure.isSelected();
    }

    public boolean isPinShowing() {
        return this.isExpanded() && this.showPin;
    }

    public void setAnimating(boolean isAnimating) {
        if (isAnimating) {
            if (this.scrollpane.getParent() != this) {
                this.addedScrollpane = true;
                this.add((IFigure)this.scrollpane);
            }
            this.scrollpane.setVerticalScrollBarVisibility(0);
        } else {
            this.scrollpane.setVerticalScrollBarVisibility(1);
            if (this.addedScrollpane) {
                this.remove((IFigure)this.scrollpane);
                this.addedScrollpane = false;
            }
        }
    }

    public void setExpanded(boolean value) {
        this.collapseToggle.setSelected(value);
    }

    public void setLayoutMode(int layoutMode) {
        PaletteContainerFlowLayout manager;
        if (this.layoutMode == layoutMode) {
            return;
        }
        this.layoutMode = layoutMode;
        if (layoutMode == 1) {
            manager = new ColumnsLayout();
            this.getContentPane().setBorder(SCROLL_PANE_BORDER);
        } else if (layoutMode == 2) {
            PaletteContainerFlowLayout fl = new PaletteContainerFlowLayout();
            fl.setMinorSpacing(0);
            fl.setMajorSpacing(0);
            manager = fl;
            this.getContentPane().setBorder(SCROLL_PANE_BORDER);
        } else {
            manager = new ToolbarLayout();
            this.getContentPane().setBorder(SCROLL_PANE_LIST_BORDER);
        }
        this.getContentPane().setLayoutManager((LayoutManager)manager);
    }

    public void setPinned(boolean pinned) {
        if (!this.isExpanded() || !this.showPin) {
            return;
        }
        this.pinFigure.setSelected(pinned);
    }

    public void setTitle(String s) {
        this.drawerLabel.setText(s);
    }

    public void setTitleIcon(Image icon) {
        this.drawerLabel.setIcon(icon);
    }

    public void showPin(boolean show) {
        this.showPin = show;
        this.handleExpandStateChanged();
    }

    private class CollapseToggle
    extends Toggle {
        public CollapseToggle(IFigure contents) {
            super(contents);
            this.setSelected(true);
            this.setRequestFocusEnabled(true);
            this.addChangeListener(new ChangeListener(){

                public void handleStateChanged(ChangeEvent e) {
                    if (e.getPropertyName().equals("selected")) {
                        Animation.markBegin();
                        DrawerFigure.this.handleExpandStateChanged();
                        Animation.run((int)150);
                    } else if (e.getPropertyName().equals("mouseover")) {
                        CollapseToggle.this.repaint();
                    }
                }
            });
        }

        public IFigure getToolTip() {
            return DrawerFigure.this.buildTooltip();
        }

        protected void paintFigure(Graphics g) {
            super.paintFigure(g);
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(this.getBounds());
            g.setForegroundColor(PaletteColorUtil.WIDGET_NORMAL_SHADOW);
            g.drawLine(r.getTopLeft(), r.getTopRight());
            g.setForegroundColor(ColorConstants.listBackground);
            g.drawLine(r.getTopLeft().getTranslated(0, 1), r.getTopRight().getTranslated(0, 1));
            r.crop(new Insets(2, 0, 0, 0));
            if (DrawerFigure.this.isExpanded()) {
                g.setForegroundColor(PaletteColorUtil.WIDGET_BACKGROUND_NORMAL_SHADOW_65);
                g.drawLine(r.getLocation(), r.getTopRight());
                r.crop(new Insets(1, 0, 0, 0));
            }
            if (!DrawerFigure.this.isExpanded()) {
                g.setForegroundColor(ColorConstants.listBackground);
                g.drawLine(r.getBottomLeft().getTranslated(0, -1), r.getBottomRight().getTranslated(0, -1));
                r.crop(new Insets(0, 0, 1, 0));
            }
            DrawerFigure.this.paintToggleGradient(g, r);
        }
    }
}

