/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.model.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.dpi.model.DPIContext;
import org.jkiss.dbeaver.dpi.model.DPIController;
import org.jkiss.dbeaver.dpi.model.DPISerializer;
import org.jkiss.dbeaver.dpi.model.client.BundleConfigGenerator;
import org.jkiss.dbeaver.dpi.model.client.BundleProcessConfig;
import org.jkiss.dbeaver.dpi.model.client.ConfigUtils;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.RestClient;

public class DPIProcessController
implements AutoCloseable {
    private static final Log log = Log.getLog(DPIProcessController.class);
    public static final int PROCESS_PAWN_TIMEOUT = 10000;
    private DPIController dpiRestClient;
    private int dpiServerPort;
    private final Process process;

    public static DPIProcessController detachDatabaseProcess(DBRProgressMonitor monitor, DBPDataSourceContainer dataSourceContainer) throws IOException {
        try {
            BundleProcessConfig processConfig = BundleConfigGenerator.generateBundleConfig(monitor, dataSourceContainer);
            return new DPIProcessController(dataSourceContainer, processConfig);
        }
        catch (Exception e) {
            throw new IOException("Error generating osgi process from datasource configuration", e);
        }
    }

    public DPIProcessController(DBPDataSourceContainer dataSourceContainer, BundleProcessConfig processConfig) throws IOException {
        DPIContext dpiContext = new DPIContext((DBRProgressMonitor)new LoggingProgressMonitor(log), dataSourceContainer);
        log.debug((Object)"Starting detached database application");
        Path serverConfigFile = processConfig.getConfigurationFolder().resolve("server.ini");
        if (Files.exists(serverConfigFile, new LinkOption[0])) {
            Files.delete(serverConfigFile);
        }
        this.process = processConfig.startProcess();
        long startTime = System.currentTimeMillis();
        while (this.process.isAlive()) {
            if (Files.exists(serverConfigFile, new LinkOption[0])) {
                Map<String, String> props = ConfigUtils.readPropertiesFromFile(serverConfigFile);
                this.dpiServerPort = CommonUtils.toInt((Object)props.get("serverPort"));
                if (this.dpiServerPort != 0) break;
                continue;
            }
            if (System.currentTimeMillis() - startTime > 10000L) {
                this.terminateChildProcess();
                throw new IOException("Error starting child DPI process. Timeout (10000) exceeded.");
            }
            RuntimeUtils.pause((int)50);
        }
        if (!this.process.isAlive()) {
            throw new IOException("Child DPI process start is failed (" + this.process.exitValue() + ")");
        }
        this.dpiRestClient = (DPIController)RestClient.builder((URI)this.getRemoteEndpoint(), DPIController.class).setGson(DPISerializer.createSerializer(dpiContext)).create();
        try {
            this.validateRestClient();
        }
        catch (Throwable e) {
            this.terminateChildProcess();
            throw new IOException("Error connecting to DPI Server", e);
        }
        dpiContext.setController(this.dpiRestClient);
    }

    private void terminateChildProcess() {
        block7: {
            if (this.dpiRestClient != null) {
                try {
                    try {
                        this.dpiRestClient.close();
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                        this.dpiRestClient = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.dpiRestClient = null;
                    throw throwable;
                }
                this.dpiRestClient = null;
            }
        }
        if (this.process != null && this.process.isAlive()) {
            this.process.destroyForcibly();
        }
    }

    private void validateRestClient() throws DBException {
        RuntimeUtils.pause((int)50);
        this.dpiRestClient.ping();
    }

    @NotNull
    private URI getRemoteEndpoint() {
        String endpoint = "http://localhost:" + this.dpiServerPort + "/";
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Wrong REST URI: " + endpoint, e);
        }
    }

    public DPIController getClient() {
        return this.dpiRestClient;
    }

    @Override
    public void close() {
        if (this.process != null) {
            this.terminateChildProcess();
        }
    }
}

