/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.redshift;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftExternalTable;
import org.jkiss.dbeaver.ext.postgresql.model.impls.redshift.RedshiftExternalTableColumn;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class RedshiftExternalSchema
extends PostgreSchema {
    private static final Log log = Log.getLog(RedshiftExternalSchema.class);
    private String esOptions;
    private final ExternalTableCache externalTableCache = new ExternalTableCache();

    public RedshiftExternalSchema(PostgreDatabase database, String name, String esOptions, ResultSet dbResult) throws SQLException {
        super(database, name, dbResult);
        this.esOptions = esOptions;
    }

    public RedshiftExternalSchema(PostgreDatabase database, String name, PostgreRole owner) {
        super(database, name, owner);
    }

    public ExternalTableCache getExternalTableCache() {
        return this.externalTableCache;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public boolean isStatisticsCollected() {
        return true;
    }

    @Override
    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
    }

    @Property(viewable=true, editable=false, updatable=false, length=PropertyLength.MULTILINE, order=50)
    public String getExternalOptions() {
        return this.esOptions;
    }

    @Override
    public PostgreTableBase getTable(DBRProgressMonitor monitor, long tableId) throws DBException {
        return null;
    }

    @Association
    public List<RedshiftExternalTable> getExternalTables(DBRProgressMonitor monitor) throws DBException {
        return this.externalTableCache.getAllObjects(monitor, this);
    }

    @Override
    public List<? extends PostgreTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.getExternalTables(monitor);
    }

    @Override
    public List<RedshiftExternalTable> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getExternalTables(monitor);
    }

    @Override
    public RedshiftExternalTable getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (RedshiftExternalTable)this.externalTableCache.getObject(monitor, this, childName);
    }

    @Override
    @NotNull
    public Class<? extends DBSEntity> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return RedshiftExternalTable.class;
    }

    public class ExternalTableCache
    extends JDBCStructLookupCache<RedshiftExternalSchema, RedshiftExternalTable, RedshiftExternalTableColumn> {
        protected ExternalTableCache() {
            super((Object)"TABLE_NAME");
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull RedshiftExternalSchema postgreSchema, @Nullable RedshiftExternalTable object, @Nullable String objectName) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM pg_catalog.svv_external_tables WHERE schemaname=?" + (object == null && objectName == null ? "" : " AND tablename=?"));
            dbStat.setString(1, postgreSchema.getName());
            if (object != null || objectName != null) {
                dbStat.setString(2, object != null ? object.getName() : objectName);
            }
            return dbStat;
        }

        protected RedshiftExternalTable fetchObject(@NotNull JDBCSession session, @NotNull RedshiftExternalSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new RedshiftExternalTable(owner, (ResultSet)dbResult);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull RedshiftExternalSchema owner, @Nullable RedshiftExternalTable forTable) throws SQLException {
            return session.getMetaData().getColumns(null, owner.getName(), forTable == null ? null : forTable.getName(), null).getSourceStatement();
        }

        protected RedshiftExternalTableColumn fetchChild(@NotNull JDBCSession session, @NotNull RedshiftExternalSchema owner, @NotNull RedshiftExternalTable table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String columnName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"COLUMN_NAME");
            int valueType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATA_TYPE");
            String typeName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TYPE_NAME");
            long columnSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"COLUMN_SIZE");
            boolean isNotNull = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"NULLABLE") == 0;
            Integer scale = null;
            try {
                scale = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"DECIMAL_DIGITS");
            }
            catch (Throwable e) {
                log.warn((Object)"Error getting column scale", e);
            }
            Integer precision = null;
            if (valueType == 2 || valueType == 3) {
                precision = (int)columnSize;
            }
            String defaultValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_DEF");
            int ordinalPos = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION");
            boolean autoGenerated = "YES".equals(JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"IS_GENERATEDCOLUMN"));
            return new RedshiftExternalTableColumn(table, true, columnName, typeName, valueType, ordinalPos, columnSize, scale, precision, isNotNull, autoGenerated, defaultValue);
        }
    }
}

