/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class AdvancedTextCellEditor
extends DialogCellEditor {
    private boolean wasNull;
    private Text textEditor;
    private FocusAdapter textFocusListener;

    public AdvancedTextCellEditor(Composite parent) {
        super(parent);
    }

    protected void doSetFocus() {
        if (this.textEditor != null) {
            this.textEditor.setFocus();
        } else {
            super.doSetFocus();
        }
    }

    protected Object doGetValue() {
        Object value = this.textEditor == null || this.textEditor.isDisposed() ? super.doGetValue() : this.textEditor.getText();
        if (this.wasNull && "".equals(value)) {
            return null;
        }
        return value;
    }

    protected void doSetValue(Object value) {
        if (value == null) {
            this.wasNull = true;
        }
        super.doSetValue((Object)CommonUtils.toString((Object)value));
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 525312);
        result.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.DOTS_BUTTON));
        return result;
    }

    protected Control createContents(final Composite cell) {
        this.textEditor = new Text(cell, 16384);
        this.textEditor.setFont(cell.getFont());
        this.textEditor.setBackground(cell.getBackground());
        this.textEditor.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
                e.detail = 0;
                this.focusLost();
            }
        });
        this.textFocusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AdvancedTextCellEditor.this.doSetValue(AdvancedTextCellEditor.this.textEditor.getText());
                UIUtils.asyncExec(() -> {
                    if (!UIUtils.hasFocus((Control)cell)) {
                        AdvancedTextCellEditor.this.fireApplyEditorValue();
                    }
                });
            }
        };
        this.textEditor.addFocusListener((FocusListener)this.textFocusListener);
        return this.textEditor;
    }

    protected void updateContents(Object value) {
        if (this.textEditor == null) {
            return;
        }
        if (value != null) {
            this.textEditor.setText((String)value);
            this.textEditor.selectAll();
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        this.textEditor.removeFocusListener((FocusListener)this.textFocusListener);
        String value = EditTextDialog.editText(cellEditorWindow.getShell(), UIMessages.edit_text_dialog_title_edit_value, (String)this.getValue());
        this.textEditor.addFocusListener((FocusListener)this.textFocusListener);
        return value;
    }

    protected int getDoubleClickTimeout() {
        return 0;
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
    }
}

