# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""UI helpers for authentication models."""

from functools import cached_property

from debusine.db.models import Group, User
from debusine.web.views.places import Place
from debusine.web.views.ui.base import UI


class UserUI(UI[User]):
    """UI helpers for User instances."""

    @cached_property
    def place(self) -> Place:
        """Return a place to show this user."""
        return Place(
            title=self.instance.get_full_name() or self.instance.username,
            url=self.instance.get_absolute_url(),
        )


class GroupUI(UI[Group]):
    """UI helpers for Group instances."""

    @cached_property
    def place(self) -> Place:
        """Return a place to show this group."""
        return Place(
            title=f"Group {self.instance}",
            url=self.instance.get_absolute_url(),
        )
