/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 by Stephen McInerney                   *
 *   spm@stedee.id.au                                                      *
 *                                                                         *
 *   $Id: regexp.c 58 2006-01-02 10:40:49Z steve $
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
 ***************************************************************************
 * regexp.c
 *
 * All the various regular expression handling
 *
 ***************************************************************************
 ***************************************************************************/

/***************************************************************************
 ***************************************************************************
 * ModificationHistory:
 **********************
 * 17-Mar-2005 steve     Initial Creation - taken from visitors
 *
 ***************************************************************************
 ***************************************************************************/


#include "dnshistory.h"

/************************************************************************
 *                              GLOBALS                                 *
 ************************************************************************/
// pcre *re_pattern_main = NULL;                   /* Main RE */
// pcre *re_pattern_filter = NULL;                 /* ignore these file types */

bool is_shown_filter = false;                   /* We have already displayed the filter; For errors */


/************************************************************************
 * re_check_errors                                                      *
 *                                                                      *
 * After an RE check, deal with any errors                              *
 ************************************************************************/
void
re_check_errors(int err, unsigned long int line_nbr, char *str_ptr)
{
    /* err: value returned from pcre_exec       */
    /* str_ptr: String that failed to match     */

    int out_vector_size;

    /* Matching failed: handle error cases */
    switch (err) {
    case PCRE_ERROR_NOMATCH:
        ERRVPRINT(VERBOSE1, msg_W_re_match_failed, line_nbr, str_ptr);
        break;
    case 0:
        /* The output vector wasn't big enough */
        out_vector_size = OVECCOUNT / 3;
        ERRVPRINT(VERBOSE1, msg_E_re_too_many_substrings, line_nbr, out_vector_size - 1);
        break;
    default:
        ERRVPRINT(VERBOSE1, msg_W_re_match_error, err, line_nbr, str_ptr);
        break;
    }
}


/************************************************************************
 * re_compile_failed                                                    *
 *                                                                      *
 * Display a failed RE Compile & where                                  *
 * FATAL failure. Will exit the run.                                    *
 ************************************************************************/
void
re_compile_failed(int err, const char *err_offset, char *re_str)
{
    ERRVPRINT(VERBOSE0, "%s %d: %s\n%s\n", msg_F_pcre_failed_compilation, err, err_offset, re_str);
    exit(V_EXIT_PCRE_COMPILE);
}


/************************************************************************
 * error_substring_extract                                              *
 *                                                                      *
 * Display a failed substring extraction                                *
 * Error Only, as this should have failed the RE                        *
 *                                                                      *
 * Typically these are seen with invalid cookie fields,                 *
 *  or super long User Agent fields.                                    *
 ************************************************************************/
void
error_substring_extract(char *failed_pattern, char *text, int substr_idx, int err, unsigned long int line_nbr)
{
    if (is_shown_filter == false) {
        VPRINT(VERBOSE1, "RegExp Pattern: %s\n", failed_pattern);
        is_shown_filter = true;
    }
    ERRVPRINT(VERBOSE1, msg_E_substring_extraction, substr_idx, line_nbr);
    switch (err) {
    case PCRE_ERROR_NOMEMORY:
        ERRVPRINT(VERBOSE1, msg_E_pcre_no_memory, "");
        break;
    case PCRE_ERROR_NOSUBSTRING:
        ERRVPRINT(VERBOSE1, msg_E_pcre_nonexist_substring, "");
        break;
    default:
        ERRVPRINT(VERBOSE1, msg_E_pcre_unknown, err);
    }
    ERRVPRINT(VERBOSE1, "  %s\n", text);
}


/************************************************************************
 ************************************************************************
 *                      END OF FILE                                     *
 ************************************************************************
 ************************************************************************/
