/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BASE64DecoderStream
extends FilterInputStream {
    private byte[] buffer;
    private int bufsize;
    private int index;
    private boolean ignoreErrors = false;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] pem_convert_array = new byte[256];
    private byte[] decode_buffer = new byte[4];

    public BASE64DecoderStream(InputStream inputStream) {
        super(inputStream);
        this.buffer = new byte[3];
        try {
            String string = System.getProperty("mail.mime.base64.ignoreerrors");
            this.ignoreErrors = string != null && !string.equalsIgnoreCase("false");
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    public BASE64DecoderStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.buffer = new byte[3];
        this.ignoreErrors = bl;
    }

    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.decode();
            if (this.bufsize == 0) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) {
                if (n3 != 0) break;
                n3 = -1;
                break;
            }
            byArray[n + n3] = (byte)n4;
            ++n3;
        }
        return n3;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    private void decode() throws IOException {
        int n;
        this.bufsize = 0;
        int n2 = 0;
        while (n2 < 4) {
            n = this.in.read();
            if (n == -1) {
                if (n2 == 0 || this.ignoreErrors) {
                    return;
                }
                String string = "Error in encoded stream: needed 4 valid base64 characters but only got " + n2 + " before EOF, the valid characters were: \"";
                int n3 = 0;
                while (n3 < n2) {
                    string = String.valueOf(string) + (char)this.decode_buffer[n3];
                    ++n3;
                }
                string = String.valueOf(string) + "\"";
                throw new IOException(string);
            }
            if (n < 0 || n >= 256 || n != 61 && pem_convert_array[n] == -1) continue;
            this.decode_buffer[n2++] = (byte)n;
        }
        n = pem_convert_array[this.decode_buffer[0] & 0xFF];
        int n4 = pem_convert_array[this.decode_buffer[1] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(n << 2 & 0xFC | n4 >>> 4 & 3);
        if (this.decode_buffer[2] == 61) {
            return;
        }
        n = n4;
        n4 = pem_convert_array[this.decode_buffer[2] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(n << 4 & 0xF0 | n4 >>> 2 & 0xF);
        if (this.decode_buffer[3] == 61) {
            return;
        }
        n = n4;
        n4 = pem_convert_array[this.decode_buffer[3] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(n << 6 & 0xC0 | n4 & 0x3F);
    }

    public static byte[] decode(byte[] byArray) {
        int n = byArray.length / 4 * 3;
        if (n == 0) {
            return byArray;
        }
        if (byArray[byArray.length - 1] == 61) {
            --n;
            if (byArray[byArray.length - 2] == 61) {
                --n;
            }
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        n = byArray.length;
        while (n > 0) {
            byte by = pem_convert_array[byArray[n2++] & 0xFF];
            byte by2 = pem_convert_array[byArray[n2++] & 0xFF];
            byArray2[n3++] = (byte)(by << 2 & 0xFC | by2 >>> 4 & 3);
            if (byArray[n2] == 61) {
                return byArray2;
            }
            by = by2;
            by2 = pem_convert_array[byArray[n2++] & 0xFF];
            byArray2[n3++] = (byte)(by << 4 & 0xF0 | by2 >>> 2 & 0xF);
            if (byArray[n2] == 61) {
                return byArray2;
            }
            by = by2;
            by2 = pem_convert_array[byArray[n2++] & 0xFF];
            byArray2[n3++] = (byte)(by << 6 & 0xC0 | by2 & 0x3F);
            n -= 4;
        }
        return byArray2;
    }

    static {
        int n = 0;
        while (n < 255) {
            BASE64DecoderStream.pem_convert_array[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < pem_array.length) {
            BASE64DecoderStream.pem_convert_array[BASE64DecoderStream.pem_array[n2]] = (byte)n2;
            ++n2;
        }
    }
}

