#ifndef STLPLUS_STRINGS
#define STLPLUS_STRINGS
////////////////////////////////////////////////////////////////////////////////

//   Author:    Andy Rushton
//   Copyright: (c) Southampton University 1999-2004
//              (c) Andy Rushton           2004 onwards
//   License:   BSD License, see ../docs/license.html

//   Header for including the whole strings library in one go

//   The strings library prints C and C++ types into a std::string

//   - it extends the numeric presentation of integers to include any radix from 2 - 36
//   - it allows the printing of data structures - useful for diagnostic dumps

////////////////////////////////////////////////////////////////////////////////

#include "string_utilities.hpp"
#include "file_utilities.hpp"

#include "string_basic.hpp"
#include "string_stl.hpp"
#include "string_stlplus.hpp"

#include "print_basic.hpp"
#include "print_stl.hpp"
#include "print_stlplus.hpp"

////////////////////////////////////////////////////////////////////////////////
#endif
