/*
 * Decompiled with CFR 0.152.
 */
package xades4j.algorithms;

import java.util.Map;
import xades4j.algorithms.Algorithm;
import xades4j.utils.CollectionUtils;

public abstract class XPathTransformBase
extends Algorithm {
    private Map<String, String> namespaces;

    protected XPathTransformBase(String uri) {
        super(uri);
    }

    protected void addNamespace(String prefix, String namespace) {
        if (null == prefix || prefix.isEmpty()) {
            throw new NullPointerException("Prefix cannot be null nor empty");
        }
        if (null == namespace || namespace.isEmpty()) {
            throw new NullPointerException("Namespace cannot be null nor empty");
        }
        this.namespaces = CollectionUtils.newIfNull(this.namespaces, 2);
        this.namespaces.put(prefix, namespace);
    }

    public Map<String, String> getNamespaces() {
        return CollectionUtils.emptyIfNull(this.namespaces);
    }
}

