/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties;

import java.util.Collection;
import xades4j.algorithms.Algorithm;
import xades4j.properties.CommitmentTypeProperty;
import xades4j.properties.DataObjectFormatProperty;
import xades4j.properties.DataObjectProperty;
import xades4j.properties.IndividualDataObjsTimeStampProperty;
import xades4j.properties.OtherSignedDataObjectProperty;
import xades4j.properties.OtherUnsignedDataObjectProperty;
import xades4j.properties.PropertyTargetException;
import xades4j.properties.SignedDataObjectProperty;
import xades4j.properties.UnsignedDataObjectProperty;
import xades4j.utils.CollectionUtils;
import xades4j.utils.PropertiesSet;

public abstract class DataObjectDesc {
    private Collection<Algorithm> transforms;
    private final PropertiesSet<SignedDataObjectProperty> signedDataObjProps = new PropertiesSet(2);
    private final PropertiesSet<UnsignedDataObjectProperty> unsignedDataObjProps = new PropertiesSet(0);

    protected DataObjectDesc() {
    }

    public final DataObjectDesc withTransform(Algorithm transf) {
        if (null == transf) {
            throw new NullPointerException("Transform cannot be null");
        }
        this.transforms = CollectionUtils.newIfNull(this.transforms, 2);
        if (!this.transforms.add(transf)) {
            throw new IllegalStateException("Transform was already added");
        }
        return this;
    }

    public Collection<Algorithm> getTransforms() {
        return CollectionUtils.emptyIfNull(this.transforms);
    }

    public final DataObjectDesc withDataObjectFormat(DataObjectFormatProperty format) {
        this.signedDataObjProps.put(format);
        this.applyProperty(format, this.signedDataObjProps);
        return this;
    }

    public final DataObjectDesc withCommitmentType(CommitmentTypeProperty commitment) {
        return this.addSignedDataObjProp(commitment);
    }

    public final DataObjectDesc withDataObjectTimeStamp(IndividualDataObjsTimeStampProperty timestamp) {
        return this.addSignedDataObjProp(timestamp);
    }

    public final DataObjectDesc withDataObjectTimeStamp() {
        return this.addSignedDataObjProp(new IndividualDataObjsTimeStampProperty());
    }

    public final DataObjectDesc withOtherDataObjectProperty(OtherSignedDataObjectProperty otherSignedDataObjProp) {
        return this.addSignedDataObjProp(otherSignedDataObjProp);
    }

    private DataObjectDesc addSignedDataObjProp(SignedDataObjectProperty prop) {
        this.addDataObjProp(this.signedDataObjProps, prop);
        return this;
    }

    public final DataObjectDesc withOtherDataObjectProperty(OtherUnsignedDataObjectProperty otherUnsignedDataObjProp) {
        this.addDataObjProp(this.unsignedDataObjProps, otherUnsignedDataObjProp);
        return this;
    }

    private <TProp extends DataObjectProperty> void addDataObjProp(PropertiesSet<TProp> bag, TProp prop) {
        bag.add(prop);
        this.applyProperty(prop, bag);
    }

    private <TProp extends DataObjectProperty> void applyProperty(TProp prop, PropertiesSet<TProp> bag) {
        try {
            prop.appliesTo(this);
        }
        catch (PropertyTargetException ex) {
            bag.remove(prop);
            throw ex;
        }
    }

    public boolean hasProperties() {
        return !this.signedDataObjProps.isEmpty() || !this.unsignedDataObjProps.isEmpty();
    }

    public Collection<SignedDataObjectProperty> getSignedDataObjProps() {
        return this.signedDataObjProps.getProperties();
    }

    public Collection<UnsignedDataObjectProperty> getUnsignedDataObjProps() {
        return this.unsignedDataObjProps.getProperties();
    }
}

