/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import xades4j.properties.ObjectIdentifier;
import xades4j.properties.SignaturePolicyBase;

public final class SignaturePolicyIdentifierProperty
extends SignaturePolicyBase {
    private final ObjectIdentifier identifier;
    private byte[] policyDocumentData;
    private InputStream policyDocumentStream;
    private String locationUrl;

    public SignaturePolicyIdentifierProperty(ObjectIdentifier identifier, InputStream policyDocumentStream) {
        if (null == policyDocumentStream) {
            throw new NullPointerException();
        }
        this.identifier = identifier;
        this.policyDocumentStream = policyDocumentStream;
    }

    public SignaturePolicyIdentifierProperty(ObjectIdentifier identifier, byte[] policyDocumentData) {
        if (null == policyDocumentData) {
            throw new NullPointerException();
        }
        this.identifier = identifier;
        this.policyDocumentData = policyDocumentData;
    }

    public byte[] getPolicyDocumentData() {
        return this.policyDocumentData;
    }

    public InputStream getPolicyDocumentStream() {
        if (null == this.policyDocumentStream) {
            this.policyDocumentStream = new ByteArrayInputStream(this.policyDocumentData);
        }
        return this.policyDocumentStream;
    }

    public ObjectIdentifier getIdentifier() {
        return this.identifier;
    }

    public SignaturePolicyIdentifierProperty withLocationUrl(String url) {
        this.locationUrl = url;
        return this;
    }

    public String getLocationUrl() {
        return this.locationUrl;
    }
}

