/*
 * Decompiled with CFR 0.152.
 */
package xades4j.properties.data;

import java.util.Collection;
import xades4j.properties.data.BaseEncapsulatedPKIData;
import xades4j.properties.data.PropertyDataObject;
import xades4j.properties.data.PropertyDataObjectStructureVerifier;
import xades4j.properties.data.PropertyDataStructureException;

class BaseEncapsulatedPKIDataStructureVerifier
implements PropertyDataObjectStructureVerifier {
    private final String propName;

    public BaseEncapsulatedPKIDataStructureVerifier(String propName) {
        this.propName = propName;
    }

    @Override
    public void verifyStructure(PropertyDataObject propData) throws PropertyDataStructureException {
        Collection<byte[]> data = ((BaseEncapsulatedPKIData)propData).getData();
        if (null == data || data.isEmpty()) {
            throw new PropertyDataStructureException("empty pki data list", this.propName);
        }
        for (byte[] d : data) {
            if (null != d) continue;
            throw new PropertyDataStructureException("null pki data", this.propName);
        }
    }
}

