/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.security.cert.X509Certificate;
import xades4j.properties.data.CertRef;
import xades4j.verification.CompleteCertRefsVerificationException;

public class CompleteCertRefsReferenceException
extends CompleteCertRefsVerificationException {
    private final X509Certificate certificate;
    private final CertRef certificateRef;
    private final String msg;

    public CompleteCertRefsReferenceException(X509Certificate certificate, CertRef certificateRef, String msg) {
        this.certificate = certificate;
        this.certificateRef = certificateRef;
        this.msg = String.format("cannot verify reference for certificate %s (%s)", certificate.getSubjectX500Principal().getName(), msg);
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public CertRef getCertificateRef() {
        return this.certificateRef;
    }

    @Override
    protected String getVerificationMessage() {
        return this.msg;
    }
}

