/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import com.google.inject.Inject;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.data.GenericDOMData;
import xades4j.verification.InvalidPropertyException;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;

class GenericDOMDataVerifier
implements QualifyingPropertyVerifier<GenericDOMData> {
    private final Map<QName, QualifyingPropertyVerifier> customElemVerifiers;

    @Inject
    GenericDOMDataVerifier(Map<QName, QualifyingPropertyVerifier> customElemVerifiers) {
        this.customElemVerifiers = customElemVerifiers;
    }

    @Override
    public QualifyingProperty verify(GenericDOMData propData, QualifyingPropertyVerificationContext ctx) throws InvalidPropertyException {
        final Element propElem = propData.getPropertyElement();
        QName propElemQName = new QName(propElem.getNamespaceURI(), propElem.getLocalName());
        QualifyingPropertyVerifier propVerifier = this.customElemVerifiers.get(propElemQName);
        if (null == propVerifier) {
            throw new InvalidPropertyException(){

                @Override
                protected String getVerificationMessage() {
                    return "Verifier not available for " + this.getPropertyName();
                }

                @Override
                public String getPropertyName() {
                    return propElem.getLocalName();
                }
            };
        }
        return propVerifier.verify(propData, ctx);
    }
}

