/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import xades4j.UnsupportedAlgorithmException;
import xades4j.properties.ObjectIdentifier;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.SignaturePolicyIdentifierProperty;
import xades4j.properties.SignaturePolicyImpliedProperty;
import xades4j.properties.data.SignaturePolicyData;
import xades4j.providers.MessageDigestEngineProvider;
import xades4j.providers.SignaturePolicyDocumentProvider;
import xades4j.utils.MessageDigestUtils;
import xades4j.verification.QualifyingPropertyVerificationContext;
import xades4j.verification.QualifyingPropertyVerifier;
import xades4j.verification.SignaturePolicyCannotDigestException;
import xades4j.verification.SignaturePolicyDigestMismatchException;
import xades4j.verification.SignaturePolicyNotAvailableException;
import xades4j.verification.SignaturePolicyVerificationException;

class SignaturePolicyVerifier
implements QualifyingPropertyVerifier<SignaturePolicyData> {
    private final SignaturePolicyDocumentProvider policyDocumentProvider;
    private final MessageDigestEngineProvider messageDigestProvider;

    @Inject
    public SignaturePolicyVerifier(SignaturePolicyDocumentProvider policyDocumentProvider, MessageDigestEngineProvider messageDigestProvider) {
        this.policyDocumentProvider = policyDocumentProvider;
        this.messageDigestProvider = messageDigestProvider;
    }

    @Override
    public QualifyingProperty verify(SignaturePolicyData propData, QualifyingPropertyVerificationContext ctx) throws SignaturePolicyVerificationException {
        ObjectIdentifier policyId = propData.getIdentifier();
        if (null == policyId) {
            return new SignaturePolicyImpliedProperty();
        }
        InputStream sigDocStream = this.policyDocumentProvider.getSignaturePolicyDocumentStream(policyId);
        if (null == sigDocStream) {
            throw new SignaturePolicyNotAvailableException(policyId, null);
        }
        try {
            MessageDigest md = this.messageDigestProvider.getEngine(propData.getDigestAlgorithm());
            byte[] sigDocDigest = MessageDigestUtils.digestStream(md, sigDocStream);
            if (!Arrays.equals(sigDocDigest, propData.getDigestValue())) {
                throw new SignaturePolicyDigestMismatchException(policyId);
            }
            SignaturePolicyIdentifierProperty signaturePolicyIdentifierProperty = new SignaturePolicyIdentifierProperty(policyId, sigDocStream).withLocationUrl(propData.getLocationUrl());
            return signaturePolicyIdentifierProperty;
        }
        catch (IOException ex) {
            throw new SignaturePolicyNotAvailableException(policyId, (Throwable)ex);
        }
        catch (UnsupportedAlgorithmException ex) {
            throw new SignaturePolicyCannotDigestException(policyId, (Throwable)ex);
        }
        finally {
            try {
                sigDocStream.close();
            }
            catch (IOException ex) {
                throw new SignaturePolicyNotAvailableException(policyId, (Throwable)ex);
            }
        }
    }
}

