/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.xml.security.utils.resolver.ResourceResolver;

public class SignatureSpecificVerificationOptions {
    static final SignatureSpecificVerificationOptions empty = new SignatureSpecificVerificationOptions();
    private String baseUriForRelativeReferences;
    private InputStream dataForAnonymousReference;
    private Date defaultVerificationDate = new Date();
    private final List<ResourceResolver> resolvers = new ArrayList<ResourceResolver>(0);

    public SignatureSpecificVerificationOptions useBaseUri(String baseUri) {
        this.baseUriForRelativeReferences = baseUri;
        return this;
    }

    String getBaseUri() {
        return this.baseUriForRelativeReferences;
    }

    public SignatureSpecificVerificationOptions useDataForAnonymousReference(InputStream data) {
        this.dataForAnonymousReference = data;
        return this;
    }

    public SignatureSpecificVerificationOptions useDataForAnonymousReference(byte[] data) {
        return this.useDataForAnonymousReference(new ByteArrayInputStream(data));
    }

    InputStream getDataForAnonymousReference() {
        return this.dataForAnonymousReference;
    }

    public SignatureSpecificVerificationOptions useResourceResolver(ResourceResolver resolver) {
        if (null == resolver) {
            throw new NullPointerException("Resolver cannot be null");
        }
        this.resolvers.add(resolver);
        return this;
    }

    List<ResourceResolver> getResolvers() {
        return this.resolvers;
    }

    public SignatureSpecificVerificationOptions setDefaultVerificationDate(Date verificationDate) {
        this.defaultVerificationDate = verificationDate != null ? verificationDate : new Date();
        return this;
    }

    Date getDefaultVerificationDate() {
        return this.defaultVerificationDate;
    }
}

