/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import xades4j.verification.InvalidXAdESFormException;
import xades4j.verification.PropertyInfo;
import xades4j.verification.XAdESForm;

class XAdESFormChecker {
    static final XAdESFormDesc XADES_BES_DESC = new XAdES_BES_Desc();
    static final XAdESFormDesc XADES_EPES_DESC = new XAdES_EPES_Desc();
    static final XAdESFormDesc XADES_T_DESC = new XAdES_T_Desc();
    static final XAdESFormDesc XADES_C_DESC = new XAdES_C_Desc();
    static final XAdESFormDesc XADES_X_DESC = new XAdES_X_Desc();
    static final XAdESFormDesc XADES_X_L_DESC = new XAdES_X_L_Desc();

    private XAdESFormChecker() {
    }

    static XAdESForm checkForm(Collection<PropertyInfo> props) throws InvalidXAdESFormException {
        HashSet<String> availablePropsNames = new HashSet<String>();
        for (PropertyInfo propInfo : props) {
            availablePropsNames.add(propInfo.getProperty().getName());
        }
        XAdESFormDesc formDesc = XADES_C_DESC;
        do {
            if (!formDesc.check(availablePropsNames)) continue;
            return formDesc.getForm();
        } while ((formDesc = formDesc.getPrevious()) != null);
        throw new InvalidXAdESFormException("Signature doesn't follow any of the XAdES forms");
    }

    static class XAdES_A_Desc
    extends XAdESFormDesc {
        public XAdES_A_Desc() {
            super(XADES_X_L_DESC);
        }

        @Override
        protected boolean checkProps(Set<String> availablePropsNames) throws InvalidXAdESFormException {
            return availablePropsNames.contains("xadesv141:ArchiveTimeStamp");
        }

        @Override
        XAdESForm getForm() {
            return XAdESForm.A;
        }
    }

    static class XAdES_X_L_Desc
    extends XAdESFormDesc {
        public XAdES_X_L_Desc() {
            super(XADES_X_DESC);
        }

        @Override
        protected boolean checkProps(Set<String> availablePropsNames) throws InvalidXAdESFormException {
            boolean hasCompRevoc;
            boolean hasCompCert = availablePropsNames.contains("CertificateValues");
            boolean xor = hasCompCert ^ (hasCompRevoc = availablePropsNames.contains("RevocationValues"));
            if (xor) {
                throw new InvalidXAdESFormException(String.format("Both %s and %s have to be present in %s form", "CertificateValues", "RevocationValues", this.getForm().toString()));
            }
            return hasCompCert;
        }

        @Override
        XAdESForm getForm() {
            return XAdESForm.X_L;
        }
    }

    static class XAdES_X_Desc
    extends XAdESFormDesc {
        public XAdES_X_Desc() {
            super(XADES_C_DESC);
        }

        @Override
        protected boolean checkProps(Set<String> availablePropsNames) throws InvalidXAdESFormException {
            return availablePropsNames.contains("SigAndRefsTimeStamp") || availablePropsNames.contains("RefsOnlyTimeStamp");
        }

        @Override
        XAdESForm getForm() {
            return XAdESForm.X;
        }
    }

    static class XAdES_C_Desc
    extends XAdESFormDesc {
        public XAdES_C_Desc() {
            super(XADES_T_DESC);
        }

        @Override
        protected boolean checkProps(Set<String> availablePropsNames) throws InvalidXAdESFormException {
            boolean hasCompRevocRefs;
            boolean hasCompCertRefs = availablePropsNames.contains("CompleteCertificateRefs");
            boolean xor = hasCompCertRefs ^ (hasCompRevocRefs = availablePropsNames.contains("CompleteRevocationRefs"));
            if (xor) {
                throw new InvalidXAdESFormException(String.format("Both %s and %s have to be present in %s form", "CompleteCertificateRefs", "CompleteRevocationRefs", this.getForm().toString()));
            }
            if (hasCompCertRefs) {
                return true;
            }
            if (availablePropsNames.contains("AttributeCertificateRefs") || availablePropsNames.contains("AttributeRevocationRefs")) {
                throw new InvalidXAdESFormException("Attr properties cannot be present without the base C form properties");
            }
            return false;
        }

        @Override
        XAdESForm getForm() {
            return XAdESForm.C;
        }
    }

    static class XAdES_T_Desc
    extends XAdESFormDesc {
        public XAdES_T_Desc() {
            super(XADES_EPES_DESC, XADES_BES_DESC);
        }

        @Override
        protected boolean checkProps(Set<String> availablePropsNames) {
            return availablePropsNames.contains("SignatureTimeStamp");
        }

        @Override
        XAdESForm getForm() {
            return XAdESForm.T;
        }
    }

    static class XAdES_EPES_Desc
    extends XAdESFormDesc {
        public XAdES_EPES_Desc() {
            super(XADES_BES_DESC);
        }

        @Override
        protected boolean checkProps(Set<String> availablePropsNames) {
            return availablePropsNames.contains("SignaturePolicyIdentifier");
        }

        @Override
        XAdESForm getForm() {
            return XAdESForm.EPES;
        }
    }

    static class XAdES_BES_Desc
    extends XAdESFormDesc {
        XAdES_BES_Desc() {
            super(new XAdESFormDesc[0]);
        }

        @Override
        protected boolean checkProps(Set<String> availablePropsNames) {
            return availablePropsNames.contains("SigningCertificate");
        }

        @Override
        XAdESForm getForm() {
            return XAdESForm.BES;
        }
    }

    private static abstract class XAdESFormDesc {
        private XAdESFormDesc[] baseForms;

        public XAdESFormDesc(XAdESFormDesc ... baseForms) {
            this.baseForms = baseForms;
        }

        boolean check(Set<String> availablePropsNames) throws InvalidXAdESFormException {
            if (!this.checkProps(availablePropsNames)) {
                return false;
            }
            if (this.baseForms.length == 0) {
                return true;
            }
            for (int i = 0; i < this.baseForms.length; ++i) {
                if (!this.baseForms[i].check(availablePropsNames)) continue;
                return true;
            }
            throw new InvalidXAdESFormException(String.format("Required base forms for %s are not present", this.getForm().toString()));
        }

        XAdESFormDesc getPrevious() {
            return this.baseForms[0];
        }

        protected abstract boolean checkProps(Set<String> var1) throws InvalidXAdESFormException;

        abstract XAdESForm getForm();
    }
}

