/*
 * Decompiled with CFR 0.152.
 */
package xades4j.verification;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import org.apache.xml.security.signature.XMLSignature;
import xades4j.properties.QualifyingProperties;
import xades4j.properties.QualifyingProperty;
import xades4j.properties.SignedDataObjectProperty;
import xades4j.properties.SignedProperties;
import xades4j.properties.SignedSignatureProperty;
import xades4j.properties.UnsignedDataObjectProperty;
import xades4j.properties.UnsignedProperties;
import xades4j.properties.UnsignedSignatureProperty;
import xades4j.providers.ValidationData;
import xades4j.utils.CollectionUtils;
import xades4j.utils.DataGetter;
import xades4j.utils.DataGetterImpl;
import xades4j.verification.PropertyInfo;
import xades4j.verification.RawDataObjectDesc;
import xades4j.verification.XAdESForm;

public class XAdESVerificationResult {
    private final XAdESForm signatureForm;
    private final XMLSignature xmlSignature;
    private final ValidationData validationData;
    private final Collection<PropertyInfo> properties;
    private final Collection<RawDataObjectDesc> signedDataObjects;
    private final DataGetter<QualifyingProperty> propertiesGetter;
    private final QualifyingProperties qualifyingProperties;

    XAdESVerificationResult(XAdESForm signatureForm, XMLSignature xmlSignature, ValidationData validationData, Collection<PropertyInfo> properties, Collection<RawDataObjectDesc> signedDataObjects) {
        this.signatureForm = signatureForm;
        this.xmlSignature = xmlSignature;
        this.validationData = validationData;
        this.properties = properties;
        this.signedDataObjects = signedDataObjects;
        this.propertiesGetter = this.createPropsGetter(properties);
        this.qualifyingProperties = this.createQualifProps();
    }

    private DataGetter<QualifyingProperty> createPropsGetter(Collection<PropertyInfo> propsInfo) {
        List<QualifyingProperty> props = CollectionUtils.project(propsInfo, new CollectionUtils.Projector<PropertyInfo, QualifyingProperty>(){

            @Override
            public QualifyingProperty project(PropertyInfo e) {
                return e.getProperty();
            }
        });
        return new DataGetterImpl<QualifyingProperty>(props);
    }

    private QualifyingProperties createQualifProps() {
        Collection<QualifyingProperty> props = this.propertiesGetter.getAll();
        List<SignedSignatureProperty> ssp = CollectionUtils.filterByType(props, SignedSignatureProperty.class);
        List<SignedDataObjectProperty> sdop = CollectionUtils.filterByType(props, SignedDataObjectProperty.class);
        List<UnsignedSignatureProperty> usp = CollectionUtils.filterByType(props, UnsignedSignatureProperty.class);
        List<UnsignedDataObjectProperty> udop = CollectionUtils.filterByType(props, UnsignedDataObjectProperty.class);
        return new QualifyingProperties(new SignedProperties((Collection<SignedSignatureProperty>)ssp, (Collection<SignedDataObjectProperty>)sdop), new UnsignedProperties((Collection<UnsignedSignatureProperty>)usp, (Collection<UnsignedDataObjectProperty>)udop));
    }

    public XAdESForm getSignatureForm() {
        return this.signatureForm;
    }

    public XMLSignature getXmlSignature() {
        return this.xmlSignature;
    }

    public String getSignatureAlgorithmUri() {
        return this.xmlSignature.getSignedInfo().getSignatureMethodURI();
    }

    public String getCanonicalizationAlgorithmUri() {
        return this.xmlSignature.getSignedInfo().getCanonicalizationMethodURI();
    }

    public ValidationData getValidationData() {
        return this.validationData;
    }

    public X509Certificate getValidationCertificate() {
        return this.validationData.getCerts().get(0);
    }

    public DataGetter<QualifyingProperty> getPropertiesFilter() {
        return this.propertiesGetter;
    }

    public Collection<PropertyInfo> getPropertiesAndData() {
        return this.properties;
    }

    public QualifyingProperties getQualifyingProperties() {
        return this.qualifyingProperties;
    }

    public Collection<RawDataObjectDesc> getSignedDataObjects() {
        return this.signedDataObjects;
    }
}

