/*
 * Decompiled with CFR 0.152.
 */
package xades4j.xml.unmarshalling;

import java.util.List;
import xades4j.properties.data.DataObjectFormatData;
import xades4j.xml.bind.xades.XmlDataObjectFormatType;
import xades4j.xml.bind.xades.XmlDocumentationReferencesType;
import xades4j.xml.bind.xades.XmlObjectIdentifierType;
import xades4j.xml.bind.xades.XmlSignedDataObjectPropertiesType;
import xades4j.xml.unmarshalling.FromXmlUtils;
import xades4j.xml.unmarshalling.PropertyUnmarshalException;
import xades4j.xml.unmarshalling.QualifyingPropertiesDataCollector;
import xades4j.xml.unmarshalling.SignedDataObjPropFromXmlConv;

class FromXmlDataObjFormatPropertyConverter
implements SignedDataObjPropFromXmlConv {
    FromXmlDataObjFormatPropertyConverter() {
    }

    @Override
    public void convertFromObjectTree(XmlSignedDataObjectPropertiesType xmlProps, QualifyingPropertiesDataCollector propertyDataCollector) throws PropertyUnmarshalException {
        List<XmlDataObjectFormatType> xmlFormats = xmlProps.getDataObjectFormat();
        if (xmlFormats.isEmpty()) {
            return;
        }
        for (XmlDataObjectFormatType xmlDataObjFormat : xmlFormats) {
            XmlDocumentationReferencesType docRefs;
            XmlObjectIdentifierType xmlObjId = xmlDataObjFormat.getObjectIdentifier();
            DataObjectFormatData dataObjFormatData = new DataObjectFormatData(xmlDataObjFormat.getObjectReference());
            dataObjFormatData.setIdentifier(FromXmlUtils.getObjectIdentifier(xmlObjId));
            dataObjFormatData.setMimeType(xmlDataObjFormat.getMimeType());
            dataObjFormatData.setEncoding(xmlDataObjFormat.getEncoding());
            dataObjFormatData.setDescription(xmlDataObjFormat.getDescription());
            if (xmlObjId != null && (docRefs = xmlDataObjFormat.getObjectIdentifier().getDocumentationReferences()) != null && !docRefs.getDocumentationReference().isEmpty()) {
                dataObjFormatData.setDocumentationUris(docRefs.getDocumentationReference());
            }
            propertyDataCollector.addDataObjectFormat(dataObjFormatData);
        }
    }
}

