/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pdfbox.io.IOUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedData;

class CMSProcessableInputStream
implements CMSTypedData {
    private InputStream in;
    private final ASN1ObjectIdentifier contentType;

    CMSProcessableInputStream(InputStream inputStream) {
        this(new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId()), inputStream);
    }

    CMSProcessableInputStream(ASN1ObjectIdentifier aSN1ObjectIdentifier, InputStream inputStream) {
        this.contentType = aSN1ObjectIdentifier;
        this.in = inputStream;
    }

    public Object getContent() {
        return this.in;
    }

    public void write(OutputStream outputStream) throws IOException, CMSException {
        IOUtils.copy((InputStream)this.in, (OutputStream)outputStream);
        this.in.close();
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }
}

