/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Calendar;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.examples.signature.CreateSignatureBase;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.ExternalSigningSupport;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.Hex;

public class CreateVisibleSignature
extends CreateSignatureBase {
    private SignatureOptions signatureOptions;
    private PDVisibleSignDesigner visibleSignDesigner;
    private final PDVisibleSigProperties visibleSignatureProperties = new PDVisibleSigProperties();
    private boolean lateExternalSigning = false;

    public boolean isLateExternalSigning() {
        return this.lateExternalSigning;
    }

    public void setLateExternalSigning(boolean bl) {
        this.lateExternalSigning = bl;
    }

    public void setVisibleSignDesigner(String string, int n, int n2, int n3, InputStream inputStream, int n4) throws IOException {
        this.visibleSignDesigner = new PDVisibleSignDesigner(string, inputStream, n4);
        this.visibleSignDesigner.xAxis((float)n).yAxis((float)n2).zoom((float)n3).adjustForRotation();
    }

    public void setVisibleSignDesigner(int n, InputStream inputStream) throws IOException {
        this.visibleSignDesigner = new PDVisibleSignDesigner(inputStream);
        this.visibleSignDesigner.zoom((float)n);
    }

    public void setVisibleSignatureProperties(String string, String string2, String string3, int n, int n2, boolean bl) {
        this.visibleSignatureProperties.signerName(string).signerLocation(string2).signatureReason(string3).preferredSize(n).page(n2).visualSignEnabled(bl).setPdVisibleSignature(this.visibleSignDesigner);
    }

    public void setVisibleSignatureProperties(String string, String string2, String string3, boolean bl) {
        this.visibleSignatureProperties.signerName(string).signerLocation(string2).signatureReason(string3).visualSignEnabled(bl).setPdVisibleSignature(this.visibleSignDesigner);
    }

    public CreateVisibleSignature(KeyStore keyStore, char[] cArray) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException {
        super(keyStore, cArray);
    }

    public void signPDF(File file, File file2, String string) throws IOException {
        this.signPDF(file, file2, string, null);
    }

    public void signPDF(File file, File file2, String string, String string2) throws IOException {
        CreateVisibleSignature createVisibleSignature;
        PDAcroForm pDAcroForm;
        if (file == null || !file.exists()) {
            throw new IOException("Document for signing does not exist");
        }
        this.setTsaUrl(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        PDDocument pDDocument = PDDocument.load((File)file);
        int n = SigUtils.getMDPPermission(pDDocument);
        if (n == 1) {
            throw new IllegalStateException("No changes to the document are permitted due to DocMDP transform parameters dictionary");
        }
        PDSignature pDSignature = this.findExistingSignature(pDDocument, string2);
        if (pDSignature == null) {
            pDSignature = new PDSignature();
        }
        if (pDDocument.getVersion() >= 1.5f && n == 0) {
            SigUtils.setMDPPermission(pDDocument, pDSignature, 2);
        }
        if ((pDAcroForm = pDDocument.getDocumentCatalog().getAcroForm()) != null && pDAcroForm.getNeedAppearances()) {
            if (pDAcroForm.getFields().isEmpty()) {
                pDAcroForm.getCOSObject().removeItem(COSName.NEED_APPEARANCES);
            } else {
                System.out.println("/NeedAppearances is set, signature may be ignored by Adobe Reader");
            }
        }
        pDSignature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        pDSignature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
        if (this.visibleSignatureProperties != null) {
            this.visibleSignatureProperties.buildSignature();
            pDSignature.setName(this.visibleSignatureProperties.getSignerName());
            pDSignature.setLocation(this.visibleSignatureProperties.getSignerLocation());
            pDSignature.setReason(this.visibleSignatureProperties.getSignatureReason());
        }
        pDSignature.setSignDate(Calendar.getInstance());
        CreateVisibleSignature createVisibleSignature2 = createVisibleSignature = this.isExternalSigning() ? null : this;
        if (this.visibleSignatureProperties != null && this.visibleSignatureProperties.isVisualSignEnabled()) {
            this.signatureOptions = new SignatureOptions();
            this.signatureOptions.setVisualSignature(this.visibleSignatureProperties.getVisibleSignature());
            this.signatureOptions.setPage(this.visibleSignatureProperties.getPage() - 1);
            pDDocument.addSignature(pDSignature, (SignatureInterface)createVisibleSignature, this.signatureOptions);
        } else {
            pDDocument.addSignature(pDSignature, (SignatureInterface)createVisibleSignature);
        }
        if (this.isExternalSigning()) {
            System.out.println("Signing externally " + file2.getName());
            ExternalSigningSupport externalSigningSupport = pDDocument.saveIncrementalForExternalSigning((OutputStream)fileOutputStream);
            byte[] byArray = this.sign(externalSigningSupport.getContent());
            if (this.isLateExternalSigning()) {
                externalSigningSupport.setSignature(new byte[0]);
                int n2 = pDSignature.getByteRange()[1] + 1;
                RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
                randomAccessFile.seek(n2);
                randomAccessFile.write(Hex.getBytes((byte[])byArray));
                randomAccessFile.close();
            } else {
                externalSigningSupport.setSignature(byArray);
            }
        } else {
            pDDocument.saveIncremental((OutputStream)fileOutputStream);
        }
        pDDocument.close();
        IOUtils.closeQuietly((Closeable)this.signatureOptions);
    }

    private PDSignature findExistingSignature(PDDocument pDDocument, String string) {
        PDSignatureField pDSignatureField;
        PDSignature pDSignature = null;
        PDAcroForm pDAcroForm = pDDocument.getDocumentCatalog().getAcroForm();
        if (pDAcroForm != null && (pDSignatureField = (PDSignatureField)pDAcroForm.getField(string)) != null) {
            pDSignature = pDSignatureField.getSignature();
            if (pDSignature == null) {
                pDSignature = new PDSignature();
                pDSignatureField.getCOSObject().setItem(COSName.V, (COSObjectable)pDSignature);
            } else {
                throw new IllegalStateException("The signature field " + string + " is already signed.");
            }
        }
        return pDSignature;
    }

    public static void main(String[] stringArray) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (stringArray.length < 4) {
            CreateVisibleSignature.usage();
            System.exit(1);
        }
        String string = null;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-tsa")) {
                if (++i >= stringArray.length) {
                    CreateVisibleSignature.usage();
                    System.exit(1);
                }
                string = stringArray[i];
            }
            if (!stringArray[i].equals("-e")) continue;
            bl = true;
        }
        File file = new File(stringArray[0]);
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        char[] cArray = stringArray[1].toCharArray();
        keyStore.load(new FileInputStream(file), cArray);
        File file2 = new File(stringArray[2]);
        CreateVisibleSignature createVisibleSignature = new CreateVisibleSignature(keyStore, (char[])cArray.clone());
        FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
        String string2 = file2.getName();
        String string3 = string2.substring(0, string2.lastIndexOf(46));
        File file3 = new File(file2.getParent(), string3 + "_signed.pdf");
        int n = 1;
        createVisibleSignature.setVisibleSignDesigner(stringArray[2], 0, 0, -50, fileInputStream, n);
        ((InputStream)fileInputStream).close();
        createVisibleSignature.setVisibleSignatureProperties("name", "location", "Security", 0, n, true);
        createVisibleSignature.setExternalSigning(bl);
        createVisibleSignature.signPDF(file2, file3, string);
    }

    private static void usage() {
        System.err.println("Usage: java " + CreateVisibleSignature.class.getName() + " <pkcs12-keystore-file> <pin> <input-pdf> <sign-image>\noptions:\n  -tsa <url>    sign timestamp using the given TSA server\n  -e            sign using external signature creation scenario");
    }
}

