/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.IOException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class SigUtils {
    private static final Log LOG = LogFactory.getLog(SigUtils.class);

    private SigUtils() {
    }

    public static int getMDPPermission(PDDocument pDDocument) {
        COSDictionary cOSDictionary;
        COSDictionary cOSDictionary2;
        COSBase cOSBase = pDDocument.getDocumentCatalog().getCOSObject().getDictionaryObject(COSName.PERMS);
        if (cOSBase instanceof COSDictionary && (cOSBase = (cOSDictionary2 = (COSDictionary)cOSBase).getDictionaryObject(COSName.DOCMDP)) instanceof COSDictionary && (cOSBase = (cOSDictionary = (COSDictionary)cOSBase).getDictionaryObject("Reference")) instanceof COSArray) {
            COSArray cOSArray = (COSArray)cOSBase;
            for (int i = 0; i < cOSArray.size(); ++i) {
                COSDictionary cOSDictionary3;
                cOSBase = cOSArray.getObject(i);
                if (!(cOSBase instanceof COSDictionary) || !COSName.DOCMDP.equals((Object)(cOSDictionary3 = (COSDictionary)cOSBase).getDictionaryObject("TransformMethod")) || !((cOSBase = cOSDictionary3.getDictionaryObject("TransformParams")) instanceof COSDictionary)) continue;
                COSDictionary cOSDictionary4 = (COSDictionary)cOSBase;
                int n = cOSDictionary4.getInt(COSName.P, 2);
                if (n < 1 || n > 3) {
                    n = 2;
                }
                return n;
            }
        }
        return 0;
    }

    public static void setMDPPermission(PDDocument pDDocument, PDSignature pDSignature, int n) {
        COSDictionary cOSDictionary = pDSignature.getCOSObject();
        COSDictionary cOSDictionary2 = new COSDictionary();
        cOSDictionary2.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"TransformParams"));
        cOSDictionary2.setInt(COSName.P, n);
        cOSDictionary2.setName(COSName.V, "1.2");
        cOSDictionary2.setNeedToBeUpdated(true);
        COSDictionary cOSDictionary3 = new COSDictionary();
        cOSDictionary3.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"SigRef"));
        cOSDictionary3.setItem("TransformMethod", (COSBase)COSName.DOCMDP);
        cOSDictionary3.setItem("DigestMethod", (COSBase)COSName.getPDFName((String)"SHA1"));
        cOSDictionary3.setItem("TransformParams", (COSBase)cOSDictionary2);
        cOSDictionary3.setNeedToBeUpdated(true);
        COSArray cOSArray = new COSArray();
        cOSArray.add((COSBase)cOSDictionary3);
        cOSDictionary.setItem("Reference", (COSBase)cOSArray);
        cOSArray.setNeedToBeUpdated(true);
        COSDictionary cOSDictionary4 = pDDocument.getDocumentCatalog().getCOSObject();
        COSDictionary cOSDictionary5 = new COSDictionary();
        cOSDictionary4.setItem(COSName.PERMS, (COSBase)cOSDictionary5);
        cOSDictionary5.setItem(COSName.DOCMDP, (COSObjectable)pDSignature);
        cOSDictionary4.setNeedToBeUpdated(true);
        cOSDictionary5.setNeedToBeUpdated(true);
    }

    public static void checkCertificateUsage(X509Certificate x509Certificate) throws CertificateParsingException {
        List<String> list;
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null && !blArray[0] && !blArray[1]) {
            LOG.error((Object)"Certificate key usage does not include digitalSignature nor nonRepudiation");
        }
        if (!((list = x509Certificate.getExtendedKeyUsage()) == null || list.contains(KeyPurposeId.id_kp_emailProtection.toString()) || list.contains(KeyPurposeId.id_kp_codeSigning.toString()) || list.contains(KeyPurposeId.anyExtendedKeyUsage.toString()) || list.contains("1.2.840.113583.1.1.5") || list.contains("1.3.6.1.4.1.311.10.3.12"))) {
            LOG.error((Object)"Certificate extended key usage does not include emailProtection, nor codeSigning, nor anyExtendedKeyUsage, nor 'Adobe Authentic Documents Trust'");
        }
    }

    public static void checkTimeStampCertificateUsage(X509Certificate x509Certificate) throws CertificateParsingException {
        List<String> list = x509Certificate.getExtendedKeyUsage();
        if (list != null && !list.contains(KeyPurposeId.id_kp_timeStamping.toString())) {
            LOG.error((Object)"Certificate extended key usage does not include timeStamping");
        }
    }

    public static void checkResponderCertificateUsage(X509Certificate x509Certificate) throws CertificateParsingException {
        List<String> list = x509Certificate.getExtendedKeyUsage();
        if (list != null && !list.contains(KeyPurposeId.id_kp_OCSPSigning.toString())) {
            LOG.error((Object)"Certificate extended key usage does not include OCSP responding");
        }
    }

    public static PDSignature getLastRelevantSignature(PDDocument pDDocument) throws IOException {
        PDSignature pDSignature;
        TreeMap<Integer, PDSignature> treeMap = new TreeMap<Integer, PDSignature>();
        PDSignature pDSignature2 = pDDocument.getSignatureDictionaries().iterator();
        while (pDSignature2.hasNext()) {
            pDSignature = (PDSignature)pDSignature2.next();
            int n = pDSignature.getByteRange()[1];
            treeMap.put(n, pDSignature);
        }
        if (treeMap.size() > 0 && ((pDSignature = (pDSignature2 = (PDSignature)treeMap.get(treeMap.lastKey())).getCOSObject().getItem(COSName.TYPE)).equals(COSName.SIG) || pDSignature.equals(COSName.DOC_TIME_STAMP))) {
            return pDSignature2;
        }
        return null;
    }
}

