/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.apache.pdfbox.examples.signature.TSAClient;
import org.apache.pdfbox.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.Attributes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public class ValidationTimeStamp {
    private TSAClient tsaClient;

    public ValidationTimeStamp(String string) throws NoSuchAlgorithmException, MalformedURLException {
        if (string != null) {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            this.tsaClient = new TSAClient(new URL(string), null, null, messageDigest);
        }
    }

    public byte[] getTimeStampToken(InputStream inputStream) throws IOException {
        return this.tsaClient.getTimeStampToken(IOUtils.toByteArray((InputStream)inputStream));
    }

    public CMSSignedData addSignedTimeStamp(CMSSignedData cMSSignedData) throws IOException {
        SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
        ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
        for (SignerInformation signerInformation : signerInformationStore.getSigners()) {
            arrayList.add(this.signTimeStamp(signerInformation));
        }
        return CMSSignedData.replaceSigners((CMSSignedData)cMSSignedData, (SignerInformationStore)new SignerInformationStore(arrayList));
    }

    private SignerInformation signTimeStamp(SignerInformation signerInformation) throws IOException {
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (attributeTable != null) {
            aSN1EncodableVector = attributeTable.toASN1EncodableVector();
        }
        byte[] byArray = this.tsaClient.getTimeStampToken(signerInformation.getSignature());
        ASN1ObjectIdentifier aSN1ObjectIdentifier = PKCSObjectIdentifiers.id_aa_signatureTimeStampToken;
        Attribute attribute = new Attribute(aSN1ObjectIdentifier, (ASN1Set)new DERSet((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])byArray)));
        aSN1EncodableVector.add((ASN1Encodable)attribute);
        Attributes attributes = new Attributes(aSN1EncodableVector);
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)new AttributeTable(attributes));
    }
}

