/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature.validation;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.examples.signature.cert.CertificateVerifier;
import org.apache.pdfbox.examples.signature.validation.CertInformationHelper;
import org.apache.pdfbox.examples.signature.validation.CertificateProccessingException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.encryption.SecurityProvider;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class CertInformationCollector {
    private static final Log LOG = LogFactory.getLog(CertInformationCollector.class);
    private static final int MAX_CERTIFICATE_CHAIN_DEPTH = 5;
    private final Map<BigInteger, X509Certificate> certificatesMap = new HashMap<BigInteger, X509Certificate>();
    private final JcaX509CertificateConverter certConverter = new JcaX509CertificateConverter();
    private CertSignatureInformation rootCertInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertSignatureInformation getLastCertInfo(PDSignature pDSignature, String string) throws CertificateProccessingException, IOException {
        CertSignatureInformation certSignatureInformation;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            byte[] byArray = pDSignature.getContents((InputStream)fileInputStream);
            certSignatureInformation = this.getCertInfo(byArray);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fileInputStream);
        return certSignatureInformation;
    }

    private CertSignatureInformation getCertInfo(byte[] byArray) throws CertificateProccessingException, IOException {
        this.rootCertInfo = new CertSignatureInformation();
        this.rootCertInfo.signatureHash = CertInformationHelper.getSha1Hash(byArray);
        try {
            CMSSignedData cMSSignedData = new CMSSignedData(byArray);
            Store store = cMSSignedData.getCertificates();
            SignerInformation signerInformation = this.processSignerStore((Store<X509CertificateHolder>)store, cMSSignedData, this.rootCertInfo);
            this.addTimestampCerts(signerInformation);
        }
        catch (CMSException cMSException) {
            LOG.error((Object)"Error occurred getting Certificate Information from Signature", (Throwable)cMSException);
            throw new CertificateProccessingException(cMSException);
        }
        return this.rootCertInfo;
    }

    private void addTimestampCerts(SignerInformation signerInformation) throws IOException, CertificateProccessingException {
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        if (attributeTable == null) {
            return;
        }
        Attribute attribute = signerInformation.getUnsignedAttributes().get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        if (attribute.getAttrValues() instanceof DERSet) {
            DERSet dERSet = (DERSet)attribute.getAttrValues();
            dERSet.getEncoded("DER");
            DERSequence dERSequence = (DERSequence)dERSet.getObjectAt(0);
            try {
                TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(dERSequence.getEncoded("DER")));
                this.rootCertInfo.tsaCerts = new CertSignatureInformation();
                Store store = timeStampToken.getCertificates();
                this.processSignerStore((Store<X509CertificateHolder>)store, timeStampToken.toCMSSignedData(), this.rootCertInfo.tsaCerts);
            }
            catch (TSPException tSPException) {
                throw new IOException("Error parsing timestamp token", tSPException);
            }
            catch (CMSException cMSException) {
                throw new IOException("Error parsing timestamp token", cMSException);
            }
        }
    }

    private SignerInformation processSignerStore(Store<X509CertificateHolder> store, CMSSignedData cMSSignedData, CertSignatureInformation certSignatureInformation) throws IOException, CertificateProccessingException {
        Collection collection = cMSSignedData.getSignerInfos().getSigners();
        SignerInformation signerInformation = (SignerInformation)collection.iterator().next();
        Collection collection2 = store.getMatches((Selector)signerInformation.getSID());
        X509Certificate x509Certificate = this.getCertFromHolder((X509CertificateHolder)collection2.iterator().next());
        Collection collection3 = store.getMatches(null);
        this.addAllCerts(collection3);
        this.traverseChain(x509Certificate, certSignatureInformation, 5);
        return signerInformation;
    }

    private void traverseChain(X509Certificate x509Certificate, CertSignatureInformation certSignatureInformation, int n) throws IOException, CertificateProccessingException {
        byte[] byArray;
        certSignatureInformation.certificate = x509Certificate;
        byte[] byArray2 = x509Certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (byArray2 != null) {
            CertInformationHelper.getAuthorityInfoExtensionValue(byArray2, certSignatureInformation);
        }
        if (certSignatureInformation.issuerUrl != null) {
            this.getAlternativeIssuerCertificate(certSignatureInformation, n);
        }
        if ((byArray = x509Certificate.getExtensionValue(Extension.cRLDistributionPoints.getId())) != null) {
            certSignatureInformation.crlUrl = CertInformationHelper.getCrlUrlFromExtensionValue(byArray);
        }
        try {
            certSignatureInformation.isSelfSigned = CertificateVerifier.isSelfSigned(x509Certificate);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CertificateProccessingException(generalSecurityException);
        }
        if (n <= 0 || certSignatureInformation.isSelfSigned) {
            return;
        }
        for (X509Certificate x509Certificate2 : this.certificatesMap.values()) {
            if (!x509Certificate.getIssuerX500Principal().equals(x509Certificate2.getSubjectX500Principal())) continue;
            try {
                x509Certificate.verify(x509Certificate2.getPublicKey(), SecurityProvider.getProvider().getName());
            }
            catch (CertificateException certificateException) {
                throw new CertificateProccessingException(certificateException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CertificateProccessingException(noSuchAlgorithmException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CertificateProccessingException(invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new CertificateProccessingException(signatureException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new CertificateProccessingException(noSuchProviderException);
            }
            LOG.info((Object)("Found the right Issuer Cert! for Cert: " + x509Certificate.getSubjectX500Principal() + "\n" + x509Certificate2.getSubjectX500Principal()));
            certSignatureInformation.issuerCertificate = x509Certificate2;
            certSignatureInformation.certChain = new CertSignatureInformation();
            this.traverseChain(x509Certificate2, certSignatureInformation.certChain, n - 1);
            break;
        }
        if (certSignatureInformation.issuerCertificate == null) {
            throw new IOException("No Issuer Certificate found for Cert: " + x509Certificate.getSubjectX500Principal());
        }
    }

    private void getAlternativeIssuerCertificate(CertSignatureInformation certSignatureInformation, int n) throws CertificateProccessingException {
        LOG.info((Object)("Get alternative issuer certificate from: " + certSignatureInformation.issuerUrl));
        try {
            URL uRL = new URL(certSignatureInformation.issuerUrl);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            InputStream inputStream = uRL.openStream();
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
            this.addCertToCertificatesMap(x509Certificate);
            certSignatureInformation.alternativeCertChain = new CertSignatureInformation();
            this.traverseChain(x509Certificate, certSignatureInformation.alternativeCertChain, n - 1);
            inputStream.close();
        }
        catch (IOException iOException) {
            LOG.error((Object)("Error getting alternative issuer certificate from " + certSignatureInformation.issuerUrl), (Throwable)iOException);
        }
        catch (CertificateException certificateException) {
            LOG.error((Object)("Error getting alternative issuer certificate from " + certSignatureInformation.issuerUrl), (Throwable)certificateException);
        }
    }

    private void addCertToCertificatesMap(X509Certificate x509Certificate) {
        if (!this.certificatesMap.containsKey(x509Certificate.getSerialNumber())) {
            this.certificatesMap.put(x509Certificate.getSerialNumber(), x509Certificate);
        }
    }

    private X509Certificate getCertFromHolder(X509CertificateHolder x509CertificateHolder) throws CertificateProccessingException {
        if (!this.certificatesMap.containsKey(x509CertificateHolder.getSerialNumber())) {
            try {
                X509Certificate x509Certificate = this.certConverter.getCertificate(x509CertificateHolder);
                this.certificatesMap.put(x509Certificate.getSerialNumber(), x509Certificate);
                return x509Certificate;
            }
            catch (CertificateException certificateException) {
                LOG.error((Object)"Certificate Exception getting Certificate from certHolder.", (Throwable)certificateException);
                throw new CertificateProccessingException(certificateException);
            }
        }
        return this.certificatesMap.get(x509CertificateHolder.getSerialNumber());
    }

    private void addAllCerts(Collection<X509CertificateHolder> collection) {
        for (X509CertificateHolder x509CertificateHolder : collection) {
            try {
                this.getCertFromHolder(x509CertificateHolder);
            }
            catch (CertificateProccessingException certificateProccessingException) {
                LOG.warn((Object)"Certificate Exception getting Certificate from certHolder.", (Throwable)certificateProccessingException);
            }
        }
    }

    public void addAllCertsFromHolders(X509CertificateHolder[] x509CertificateHolderArray) throws CertificateProccessingException {
        this.addAllCerts(Arrays.asList(x509CertificateHolderArray));
    }

    CertSignatureInformation getCertInfo(X509Certificate x509Certificate) throws CertificateProccessingException {
        try {
            CertSignatureInformation certSignatureInformation = new CertSignatureInformation();
            this.traverseChain(x509Certificate, certSignatureInformation, 5);
            return certSignatureInformation;
        }
        catch (IOException iOException) {
            throw new CertificateProccessingException(iOException);
        }
    }

    public Map<BigInteger, X509Certificate> getCertificatesMap() {
        return this.certificatesMap;
    }

    public class CertSignatureInformation {
        private X509Certificate certificate;
        private String signatureHash;
        private boolean isSelfSigned = false;
        private String ocspUrl;
        private String crlUrl;
        private String issuerUrl;
        private X509Certificate issuerCertificate;
        private CertSignatureInformation certChain;
        private CertSignatureInformation tsaCerts;
        private CertSignatureInformation alternativeCertChain;

        public String getOcspUrl() {
            return this.ocspUrl;
        }

        public void setOcspUrl(String string) {
            this.ocspUrl = string;
        }

        public void setIssuerUrl(String string) {
            this.issuerUrl = string;
        }

        public String getCrlUrl() {
            return this.crlUrl;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }

        public boolean isSelfSigned() {
            return this.isSelfSigned;
        }

        public X509Certificate getIssuerCertificate() {
            return this.issuerCertificate;
        }

        public String getSignatureHash() {
            return this.signatureHash;
        }

        public CertSignatureInformation getCertChain() {
            return this.certChain;
        }

        public CertSignatureInformation getTsaCerts() {
            return this.tsaCerts;
        }

        public CertSignatureInformation getAlternativeCertChain() {
            return this.alternativeCertChain;
        }
    }
}

