#include "SDL_opengl.h"
#include "robot.h"


#include <iostream>

namespace models {

static GLuint robot_dl=0;

void robot::draw() {
	dldraw();
}
void robot::dldraw() {
	if (robot_dl==0) { sdraw(); return; }
	glCallList(robot_dl);
}

void robot::gen_dl() {
	robot_dl=glGenLists(1);
	glNewList(robot_dl,GL_COMPILE);
	sdraw();
	glEndList();
	std::cout << " loaded robot " << robot_dl << std::endl;
}
namespace mtl_robot {
typedef enum MTL {
m_shirt,
m_skin,
m_trousers,
m_last
};
} //namespace
void robot::material (int id) {
	switch (id) {
		case mtl_robot::m_shirt:
static const GLfloat m_shirt_diffuse[] = {0.00000e+0,0.00000e+0,1.00000};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_shirt_diffuse);
static const GLfloat m_shirt_ambient[] = {0.00000e+0,0.273333,1.00000};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_shirt_ambient);
static const GLfloat m_shirt_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_shirt_emissive);
			break;
		case mtl_robot::m_skin:
static const GLfloat m_skin_diffuse[] = {0.946667,0.973333,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_skin_diffuse);
static const GLfloat m_skin_ambient[] = {0.962133,1.00000,5.33333e-2};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_skin_ambient);
static const GLfloat m_skin_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_skin_emissive);
			break;
		case mtl_robot::m_trousers:
static const GLfloat m_trousers_diffuse[] = {0.00000e+0,0.953333,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_trousers_diffuse);
static const GLfloat m_trousers_ambient[] = {0.00000e+0,0.973333,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_trousers_ambient);
static const GLfloat m_trousers_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_trousers_emissive);
			break;
	}
}
float robot::minx() { return -0.173244 ; }
float robot::miny() { return -0.00277653 ; }
float robot::minz() { return -0.0716584 ; }
float robot::maxx() { return 0.173244; }
float robot::maxy() { return 0.463712; }
float robot::maxz() { return 0.0716584; }
float robot::radius() { return 0.500178; }
void robot::sdraw() {
const float vertices[62][3]={
	{0.10000000,0.19722347,3.7400000e-2},
	{0.10000000,0.19722347,-3.7400000e-2},
	{-0.10000000,0.19722347,3.7400000e-2},
	{-0.10000000,0.19722347,-3.7400000e-2},
	{0.10000000,0.32131236,3.7400000e-2},
	{0.10000000,0.32131236,-3.7400000e-2},
	{-0.10000000,0.32131236,-3.7400000e-2},
	{-0.10000000,0.32131236,3.7400000e-2},
	{0.10000000,0.25926792,3.7400000e-2},
	{0.10000000,0.25926792,-3.7400000e-2},
	{-0.10000000,0.25926792,-3.7400000e-2},
	{-0.10000000,0.25926792,3.7400000e-2},
	{-3.3333333e-2,0.32131236,-3.7400000e-2},
	{3.3333333e-2,0.32131236,-3.7400000e-2},
	{3.3333333e-2,0.32131236,3.7400000e-2},
	{-3.3333333e-2,0.32131236,3.7400000e-2},
	{0.0000000e+0,0.19722347,3.7400000e-2},
	{0.0000000e+0,0.19722347,-3.7400000e-2},
	{-0.10000000,0.32131236,-3.7400000e-2},
	{-0.10000000,0.32131236,3.7400000e-2},
	{-0.10000000,0.25926792,-3.7400000e-2},
	{-0.10000000,0.25926792,3.7400000e-2},
	{-0.17324444,0.20594783,-3.7400000e-2},
	{-0.17324444,0.20594783,3.7400000e-2},
	{-0.17324444,0.26799227,3.7400000e-2},
	{-0.17324444,0.26799227,-3.7400000e-2},
	{0.10000000,0.32131236,3.7400000e-2},
	{0.10000000,0.32131236,-3.7400000e-2},
	{0.10000000,0.25926792,3.7400000e-2},
	{0.10000000,0.25926792,-3.7400000e-2},
	{0.17324444,0.20594783,3.7400000e-2},
	{0.17324444,0.20594783,-3.7400000e-2},
	{0.17324444,0.26799227,-3.7400000e-2},
	{0.17324444,0.26799227,3.7400000e-2},
	{-3.3333333e-2,0.32131236,-3.7400000e-2},
	{3.3333333e-2,0.32131236,-3.7400000e-2},
	{3.3333333e-2,0.32131236,3.7400000e-2},
	{-3.3333333e-2,0.32131236,3.7400000e-2},
	{-8.2810000e-2,0.34886792,-7.1658400e-2},
	{-8.2810000e-2,0.34886792,7.1658400e-2},
	{8.2810000e-2,0.34886792,7.1658400e-2},
	{8.2810000e-2,0.34886792,-7.1658400e-2},
	{-8.2810000e-2,0.46371236,-7.1658400e-2},
	{-8.2810000e-2,0.46371236,7.1658400e-2},
	{8.2810000e-2,0.46371236,7.1658400e-2},
	{8.2810000e-2,0.46371236,-7.1658400e-2},
	{0.10000000,-2.7765264e-3,3.7400000e-2},
	{0.10000000,0.19722347,3.7400000e-2},
	{0.10000000,0.19722347,-3.7400000e-2},
	{0.10000000,-2.7765264e-3,-3.7400000e-2},
	{-0.10000000,-2.7765264e-3,3.7400000e-2},
	{-0.10000000,0.19722347,3.7400000e-2},
	{-0.10000000,0.19722347,-3.7400000e-2},
	{-0.10000000,-2.7765264e-3,-3.7400000e-2},
	{5.0000000e-2,-2.7765264e-3,3.7400000e-2},
	{-9.6831980e-19,0.12504570,3.7400000e-2},
	{-5.0000000e-2,-2.7765264e-3,3.7400000e-2},
	{5.0000000e-2,-2.7765264e-3,-3.7400000e-2},
	{3.6117080e-18,0.12504570,-3.7400000e-2},
	{-5.0000000e-2,-2.7765264e-3,-3.7400000e-2},
	{0.0000000e+0,0.19722347,3.7400000e-2},
	{0.0000000e+0,0.19722347,-3.7400000e-2},
};
const float normals[62][3]={
	{0.57735027,-0.57735027,0.57735027},
	{0.57735027,-0.57735027,-0.57735027},
	{-0.57735027,-0.57735027,0.57735027},
	{-0.57735027,-0.57735027,-0.57735027},
	{0.57735027,0.57735027,0.57735027},
	{0.57735027,0.57735027,-0.57735027},
	{-0.57735027,0.57735027,-0.57735027},
	{-0.57735027,0.57735027,0.57735027},
	{0.89442719,0.0000000e+0,0.44721360},
	{0.89442719,0.0000000e+0,-0.44721360},
	{-0.89442719,0.0000000e+0,-0.44721360},
	{-0.89442719,0.0000000e+0,0.44721360},
	{0.0000000e+0,0.89442719,-0.44721360},
	{0.0000000e+0,0.89442719,-0.44721360},
	{0.0000000e+0,0.89442719,0.44721360},
	{0.0000000e+0,0.89442719,0.44721360},
	{0.0000000e+0,-0.70710678,0.70710678},
	{0.0000000e+0,-0.70710678,-0.70710678},
	{0.30474850,0.59879569,-0.74065651},
	{0.30474850,0.59879569,0.74065651},
	{0.77725267,-0.39557163,-0.48928660},
	{0.77725267,-0.39557163,0.48928660},
	{-0.30474851,-0.59879569,-0.74065651},
	{-0.30474851,-0.59879569,0.74065651},
	{-0.77725267,0.39557163,0.48928660},
	{-0.77725267,0.39557163,-0.48928660},
	{-0.30474850,0.59879569,0.74065651},
	{-0.30474850,0.59879569,-0.74065651},
	{-0.77725267,-0.39557163,0.48928660},
	{-0.77725267,-0.39557163,-0.48928660},
	{0.30474851,-0.59879569,0.74065651},
	{0.30474851,-0.59879569,-0.74065651},
	{0.77725267,0.39557163,-0.48928660},
	{0.77725267,0.39557163,0.48928660},
	{-0.17572099,-0.95806467,-0.22634978},
	{0.17572099,-0.95806467,-0.22634978},
	{0.17572099,-0.95806467,0.22634978},
	{-0.17572099,-0.95806467,0.22634978},
	{-0.53965513,-0.60002215,-0.59054700},
	{-0.53965513,-0.60002215,0.59054700},
	{0.53965513,-0.60002215,0.59054700},
	{0.53965513,-0.60002215,-0.59054700},
	{-0.57735027,0.57735027,-0.57735027},
	{-0.57735027,0.57735027,0.57735027},
	{0.57735027,0.57735027,0.57735027},
	{0.57735027,0.57735027,-0.57735027},
	{0.57735027,-0.57735027,0.57735027},
	{0.57735027,0.57735027,0.57735027},
	{0.57735027,0.57735027,-0.57735027},
	{0.57735027,-0.57735027,-0.57735027},
	{-0.57735027,-0.57735027,0.57735027},
	{-0.57735027,0.57735027,0.57735027},
	{-0.57735027,0.57735027,-0.57735027},
	{-0.57735027,-0.57735027,-0.57735027},
	{-0.48229338,-0.70653691,0.51787903},
	{2.4248638e-17,-0.34228499,0.93959618},
	{0.48229338,-0.70653691,0.51787903},
	{-0.48229338,-0.70653691,-0.51787903},
	{2.4248638e-17,-0.34228499,-0.93959618},
	{0.48229338,-0.70653691,-0.51787903},
	{0.0000000e+0,0.44721360,0.89442719},
	{0.0000000e+0,0.44721360,-0.89442719},
};
//o torso
material(mtl_robot::m_shirt);
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
material(mtl_robot::m_skin);
glBegin(GL_POLYGON);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
glEnd();
material(mtl_robot::m_trousers);
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
}
} //namespace
