!{\src2tex{textfont=tt}}
!!****m* etsf_split/etsf_io_split_allocate
!! NAME
!!  etsf_io_split_allocate
!!
!! FUNCTION
!!    Allocate internal pointers of structure etsf_split given the dimensions
!!    in @dims. The split arrays are allocated only if the associated dimensions
!!    are different from etsf_no_dimension (see ETSF_IO_CONSTANTS) and from
!!    the associated full dimension. To free a split structure, use
!!    etsf_io_split_free().
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * dims <type(etsf_dims)> = 
!!     these dimensions define which arrays of argument @split should be allocated ;
!!     it give also the size for these arrays.
!! OUTPUT
!! * split <type(etsf_split)> = 
!!     read the @dims argument to allocate the required split arrays, use
!!     etsf_io_split_free() when the split structure is not needed anymore.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_split_allocate(split, dims)

  !Arguments ------------------------------------
  type(etsf_split), intent(out) :: split
  type(etsf_dims), intent(in) :: dims

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_split_allocate'


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_split_allocate : enter'
!ENDDEBUG

  if (dims%my_number_of_kpoints /= etsf_no_dimension .and. &
    & dims%my_number_of_kpoints /= dims%number_of_kpoints) then 
    allocate(split%my_kpoints(dims%my_number_of_kpoints))
    split%my_kpoints(:) = -1
  end if
  if (dims%my_number_of_grid_points_vect3 /= etsf_no_dimension .and. &
    & dims%my_number_of_grid_points_vect3 /= dims%number_of_grid_points_vector3) then 
    allocate(split%my_grid_points_vector3(dims%my_number_of_grid_points_vect3))
    split%my_grid_points_vector3(:) = -1
  end if
  if (dims%my_number_of_spins /= etsf_no_dimension .and. &
    & dims%my_number_of_spins /= dims%number_of_spins) then 
    allocate(split%my_spins(dims%my_number_of_spins))
    split%my_spins(:) = -1
  end if
  if (dims%my_number_of_grid_points_vect1 /= etsf_no_dimension .and. &
    & dims%my_number_of_grid_points_vect1 /= dims%number_of_grid_points_vector1) then 
    allocate(split%my_grid_points_vector1(dims%my_number_of_grid_points_vect1))
    split%my_grid_points_vector1(:) = -1
  end if
  if (dims%my_number_of_grid_points_vect2 /= etsf_no_dimension .and. &
    & dims%my_number_of_grid_points_vect2 /= dims%number_of_grid_points_vector2) then 
    allocate(split%my_grid_points_vector2(dims%my_number_of_grid_points_vect2))
    split%my_grid_points_vector2(:) = -1
  end if
  if (dims%my_max_number_of_coefficients /= etsf_no_dimension .and. &
    & dims%my_max_number_of_coefficients /= dims%max_number_of_coefficients) then 
    allocate(split%my_coefficients(dims%my_max_number_of_coefficients))
    split%my_coefficients(:) = -1
  end if
  if (dims%my_number_of_components /= etsf_no_dimension .and. &
    & dims%my_number_of_components /= dims%number_of_components) then 
    allocate(split%my_components(dims%my_number_of_components))
    split%my_components(:) = -1
  end if
  if (dims%my_max_number_of_states /= etsf_no_dimension .and. &
    & dims%my_max_number_of_states /= dims%max_number_of_states) then 
    allocate(split%my_states(dims%my_max_number_of_states))
    split%my_states(:) = -1
  end if


!DEBUG
!write (*,*) 'etsf_io_split_allocate : exit'
!ENDDEBUG

end subroutine etsf_io_split_allocate
!!***
