/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.docbook.editor;

import org.dbdoclet.tag.docbook.Article;
import org.dbdoclet.tag.docbook.BaseTagFactory;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.xiphias.XmlConstants;

public class HtmlEditor extends DocBookEditor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));
		BaseTagFactory dbfactory = getTagFactory();

		Article article = dbfactory.createArticle();

		HtmlElement child = getHtmlElement();

		String lang = child.getAttribute("lang");

		if (lang == null) {
			lang = child.getAttributeNS(XmlConstants.NAMESPACE_XML, "lang");
		}

		setCurrent(article);
		traverse(true);

		article.setAttribute("xmlns", "http://docbook.org/ns/docbook");
		article.setAttribute("version", "5.0");

		if (lang != null) {
			article.setAttributeNS(XmlConstants.NAMESPACE_XML, "xml:lang", lang.toLowerCase());
		}

		getParent().appendChild(getCurrent());

		return finalizeValues();
	}
}
