Configuring ironic-api behind mod_wsgi
--------------------------------------

Bare Metal service comes with an example file for configuring the
``ironic-api`` service to run behind Apache with mod_wsgi.

.. note::
   This is optional, the ironic APIs can be run using
   independent scripts that provide HTTP servers. But it is generally
   considered more performant and flexible to run them using a generic
   HTTP server that supports WSGI (such as Apache or nginx).

#. Install the apache service:

   Fedora/RHEL8/CentOS8::

       sudo dnf install httpd

   Debian/Ubuntu::

       apt-get install apache2

   SUSE::

       zypper install apache2


#. Download the ``etc/apache2/ironic`` file from the
   `Ironic project tree <https://opendev.org/openstack/ironic/raw/branch/master/etc/apache2/ironic>`_
   and copy it to the apache sites:

   Fedora/RHEL8/CentOS8::

       sudo cp etc/apache2/ironic /etc/httpd/conf.d/ironic.conf

   Debian/Ubuntu::

       sudo cp etc/apache2/ironic /etc/apache2/sites-available/ironic.conf

   SUSE::

       sudo cp etc/apache2/ironic /etc/apache2/vhosts.d/ironic.conf


#. Edit the recently copied ``<apache-configuration-dir>/ironic.conf``:

   #. Modify the ``WSGIDaemonProcess``, ``APACHE_RUN_USER`` and
      ``APACHE_RUN_GROUP`` directives to set the user and group values to
      an appropriate user on your server.

   #. Modify the ``WSGIScriptAlias`` directive to point to the automatically
      generated ``ironic-api-wsgi`` script that is located in `IRONIC_BIN`
      directory.

   #. Modify the ``Directory`` directive to set the path to the Ironic API code.

   #. Modify the ``ErrorLog`` and ``CustomLog`` to redirect the logs
      to the right directory (on Red Hat systems this is usually under
      /var/log/httpd).

#. Stop and disable the ironic-api service. If ironic-api service is
   started, the port will be occupied. Apach will fail to start:

   Fedora/RHEL8/CentOS8/SUSE::

       sudo systemctl stop openstack-ironic-api
       sudo systemctl disable openstack-ironic-api

   Debian/Ubuntu::

       sudo service ironic-api stop
       sudo service ironic-api disable

#. Enable the apache ``ironic`` in site and reload:

   Fedora/RHEL8/CentOS8::

       sudo systemctl reload httpd

   Debian/Ubuntu::

       sudo a2ensite ironic
       sudo service apache2 reload

   SUSE::

       sudo systemctl reload apache2

.. note::
   The file ``ironic-api-wsgi`` is automatically generated by pbr and is
   available in `IRONIC_BIN` directory. It should not be modified.

Configure another WSGI container
--------------------------------

A slightly different approach has to be used for WSGI containers that cannot
use ``ironic-api-wsgi``. For example, for *gunicorn*:

.. code-block:: console

    gunicorn -b 0.0.0.0:6385 'ironic.api.wsgi:initialize_wsgi_app(argv=[])'

If you want to pass a configuration file, use:

.. code-block:: console

    gunicorn -b 0.0.0.0:6385 \
        'ironic.api.wsgi:initialize_wsgi_app(argv=["ironic-api", "--config-file=/path/to/_ironic.conf"])'
