/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.TargetInsnNode;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.blocks.BlockProcessor;
import jadx.core.dex.visitors.blocks.BlockSplitter;
import jadx.core.utils.BlockUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class SimpleModeHelper {
    private final MethodNode mth;
    private final BitSet startLabel;
    private final BitSet endGoto;

    public SimpleModeHelper(MethodNode mth) {
        this.mth = mth;
        this.startLabel = BlockUtils.newBlocksBitSet(mth);
        this.endGoto = BlockUtils.newBlocksBitSet(mth);
    }

    public List<BlockNode> prepareBlocks() {
        int last;
        this.removeEmptyBlocks();
        List<BlockNode> blocksList = this.getSortedBlocks();
        blocksList.removeIf(b -> b.equals(this.mth.getEnterBlock()) || b.equals(this.mth.getExitBlock()));
        this.unbindExceptionHandlers();
        if (blocksList.isEmpty()) {
            return Collections.emptyList();
        }
        @Nullable BlockNode prev = null;
        int blocksCount = blocksList.size();
        for (int i = 0; i < blocksCount; ++i) {
            BlockNode block = blocksList.get(i);
            BlockNode nextBlock = i + 1 == blocksCount ? null : blocksList.get(i + 1);
            List<BlockNode> preds = block.getPredecessors();
            int predsCount = preds.size();
            if (predsCount > 1) {
                this.startLabel.set(block.getId());
            } else if (predsCount == 1 && prev != null && !prev.equals(preds.get(0))) {
                if (!block.contains(AFlag.EXC_BOTTOM_SPLITTER)) {
                    this.startLabel.set(block.getId());
                }
                if (prev.getSuccessors().size() == 1 && !this.mth.isPreExitBlocks(prev)) {
                    this.endGoto.set(prev.getId());
                }
            }
            InsnNode lastInsn = BlockUtils.getLastInsn(block);
            if (lastInsn instanceof TargetInsnNode) {
                this.processTargetInsn(block, lastInsn, nextBlock);
            }
            if (block.contains(AType.EXC_HANDLER)) {
                this.startLabel.set(block.getId());
            }
            if (nextBlock == null && !this.mth.isPreExitBlocks(block)) {
                this.endGoto.set(block.getId());
            }
            prev = block;
        }
        if (this.mth.isVoidReturn() && blocksList.get(last = blocksList.size() - 1).contains(AFlag.RETURN)) {
            blocksList.remove(last);
        }
        return blocksList;
    }

    private void removeEmptyBlocks() {
        for (BlockNode block : this.mth.getBasicBlocks()) {
            if (!block.getInstructions().isEmpty() || block.getPredecessors().size() <= 0 || block.getSuccessors().size() != 1) continue;
            BlockNode successor = block.getSuccessors().get(0);
            List<BlockNode> predecessors = block.getPredecessors();
            BlockSplitter.removeConnection(block, successor);
            if (predecessors.size() == 1) {
                BlockSplitter.replaceConnection(predecessors.get(0), block, successor);
            } else {
                for (BlockNode pred : new ArrayList<BlockNode>(predecessors)) {
                    BlockSplitter.replaceConnection(pred, block, successor);
                }
            }
            block.add(AFlag.REMOVE);
        }
        BlockProcessor.removeMarkedBlocks(this.mth);
    }

    private void unbindExceptionHandlers() {
        if (this.mth.isNoExceptionHandlers()) {
            return;
        }
        for (ExceptionHandler handler : this.mth.getExceptionHandlers()) {
            BlockNode handlerBlock = handler.getHandlerBlock();
            if (handlerBlock == null) continue;
            BlockSplitter.removePredecessors(handlerBlock);
        }
    }

    private void processTargetInsn(BlockNode block, InsnNode lastInsn, @Nullable BlockNode next) {
        if (lastInsn instanceof IfNode) {
            IfNode ifInsn = (IfNode)lastInsn;
            BlockNode thenBlock = ifInsn.getThenBlock();
            if (Objects.equals(next, thenBlock)) {
                ifInsn.invertCondition();
                this.startLabel.set(ifInsn.getThenBlock().getId());
            } else {
                this.startLabel.set(thenBlock.getId());
            }
            ifInsn.normalize();
        } else {
            for (BlockNode successor : block.getSuccessors()) {
                this.startLabel.set(successor.getId());
            }
        }
    }

    public boolean isNeedStartLabel(BlockNode block) {
        return this.startLabel.get(block.getId());
    }

    public boolean isNeedEndGoto(BlockNode block) {
        return this.endGoto.get(block.getId());
    }

    private List<BlockNode> getSortedBlocks() {
        ArrayList<BlockNode> list = new ArrayList<BlockNode>(this.mth.getBasicBlocks().size());
        BlockUtils.dfsVisit(this.mth, list::add);
        return list;
    }
}

