module.exports = "const webviewLib = {};\n\nlet manualDownloadResourceElements = [];\n\nwebviewLib.onUnloadedResourceClick = function(event) {\n\tconst resourceId = event.currentTarget.getAttribute('data-resource-id');\n\twebviewLib.options_.postMessage(`markForDownload:${resourceId}`);\n};\n\nwebviewLib.setupResourceManualDownload = function() {\n\tfor (const element of manualDownloadResourceElements) {\n\t\telement.style.cursor = 'default';\n\t\telement.removeEventListener('click', webviewLib.onUnloadedResourceClick);\n\t}\n\n\tmanualDownloadResourceElements = [];\n\n\tconst elements = document.getElementsByClassName('resource-status-notDownloaded');\n\n\tfor (const element of elements) {\n\t\telement.style.cursor = 'pointer';\n\t\telement.addEventListener('click', webviewLib.onUnloadedResourceClick);\n\t\tmanualDownloadResourceElements.push(element);\n\t}\n};\n\nwebviewLib.handleInternalLink = function(event, anchorNode) {\n\tconst href = anchorNode.getAttribute('href');\n\tif (!href) return false;\n\n\tif (href.indexOf('#') === 0) {\n\t\tevent.preventDefault();\n\t\t// let old_hash = location.hash;\n\n\t\tlocation.hash = href;\n\n\t\t// HACK\n\t\t// For some reason anchors at the bottom cause the webview to move itself\n\t\t// so that the content is aligned with the top of the screen\n\t\t// This basically refreshes the scroll view so that is returns to a normal\n\t\t// position, the scroll positions stays correct though\n\t\t// Additionally an anchor could not be clicked twice because the location\n\t\t// would not change, this fixes that also\n\t\t//\n\t\t// Commented out to fix https://github.com/laurent22/joplin/issues/2141\n\t\t// We might need to fix a better fix to the previous bug.\n\t\t//\n\t\t// setTimeout(function() {\n\t\t// \tlocation.hash = old_hash;\n\t\t// }, 10);\n\t\treturn true;\n\t}\n\n\treturn false;\n};\n\nwebviewLib.getParentAnchorElement = function(element) {\n\tlet counter = 0;\n\twhile (true) {\n\t\tif (counter++ >= 10000) {\n\t\t\tconsole.warn('been looping for too long - exiting');\n\t\t\treturn null;\n\t\t}\n\n\t\tif (!element) return null;\n\t\tif (element.nodeName.toUpperCase() === 'A') return element;\n\t\telement = element.parentElement;\n\t}\n};\n\nwebviewLib.cloneError = function(error) {\n\treturn {\n\t\tmessage: error.message,\n\t\tstack: error.stack,\n\t};\n};\n\nwebviewLib.logEnabledEventHandler = function(fn) {\n\treturn function(event) {\n\t\ttry {\n\t\t\treturn fn(event);\n\t\t} catch (error) {\n\t\t\twebviewLib.options_.postMessage(`error:${JSON.stringify(webviewLib.cloneError(error))}`);\n\t\t\tthrow error;\n\t\t}\n\t};\n};\n\nwebviewLib.initialize = function(options) {\n\twebviewLib.options_ = options;\n};\n\ndocument.addEventListener('click', function(event) {\n\tconst anchor = webviewLib.getParentAnchorElement(event.target);\n\tif (!anchor) return;\n\n\t// Prevent URLs added via <a> tags from being opened within the application itself\n\t// otherwise it would open the whole website within the WebView.\n\n\t// Note that we already handle some links in html_inline.js, however not all of them\n\t// go through this plugin, in particular links coming from third-party packages such\n\t// as Katex or Mermaid.\n\tif (!anchor.hasAttribute('data-from-md')) {\n\t\tif (webviewLib.handleInternalLink(event, anchor)) return;\n\t\tevent.preventDefault();\n\t\tif (anchor.getAttribute('href')) webviewLib.options_.postMessage(anchor.getAttribute('href'));\n\t\treturn;\n\t}\n\n\t// If this is an internal link, jump to the anchor directly\n\tif (anchor.hasAttribute('data-from-md')) {\n\t\tif (webviewLib.handleInternalLink(event, anchor)) return;\n\t}\n});\n";