---
tweet: What's new in Joplin 2.10
forum_url: https://discourse.joplinapp.org/t/30716
---

# What's new in Joplin 2.10

Great news! Joplin 2.10 is here and we've made some amazing improvements and bug fixes, with a focus on the mobile app.

# New design for "New note" and "New to-do" buttons

We're excited to announce that we've made it even easier to create new notes and to-do lists with new designs for the "New note" and "New to-do" buttons.

If there is enough space, the button labels will be shown in full:

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20230508-new-note-1.png)

While for those who prefer a more narrow note list, only the button icons will be shown:

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20230508-new-note-2.png)

It's a small improvement, but we're confident it will make the app even more intuitive for new users.
 
# Fixes and improvements

This version includes 30 bug fixes and 16 general improvements. Let's dive into some of the highlights:

- Self Not Found and Pedro have been working tirelessly on improving the pasting of plain text in the application, and we're happy to say that there is now a brand new "Paste as text" option in the Edit menu.

- For our amazing plugin developers out there, we have added a few new APIs and fixed a bug that was preventing certain plugins from starting. You can now get even more creative with your plugins!

- Tao Klerks, has been hard at work fixing and improving the custom sort order of the note list. No more notes in the wrong position when you drop them! Plus, custom sort order is now synchronised too.

- We've also fixed a few bugs with our Web Clipper, including an issue where certain pages wouldn't import their images. A new Web Clipper has also been released, so you can clip to your heart's content!

Last but not least, we have modernised both the desktop and mobile application modules, just [as we previously announced](https://joplinapp.org/news/20221115-renovate/). Although these changes may not be visible to you, they required a lot of work! But the result is that our applications are now more stable and secure, and it will be easier to maintain them in the long run. We're using a tool called [Renovate](https://www.mend.io/free-developer-tools/renovate/), which will automatically propose package updates that we will review. In total, we've updated a whopping 633 packages so far!

# Android app is available in the Play Store

Our latest version, 2.10, is now back in the Play Store and ready for download! Although we had to skip 2.9 due to some of Google's requirements, we worked hard to ensure that our app complies with their standards, and we are excited to announce that we are back and better than ever! Our iOS version is also available, so you can continue to enjoy the app regardless of the platform you use.

## Biometrics support

To make your experience even more secure, our Android and iOS apps now support biometric unlock! With just a quick scan of your fingerprint or Face ID, you can unlock your app in no time. To enable this beta feature, just head over to the settings and click on "Use biometrics to secure access to the app".

We've tested this feature thoroughly during prerelease, and have already fixed all known issues. However we still consider it as a beta feature for now, so if you run into any issues please let us know.

## Support for multiple profile

We're thrilled to announce that multiple profiles are now supported in our mobile app! To create a new profile, simply go to the Configuration screen and click on "Manage profiles" under the Tools section.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20230508-biometrics-1.png)

From there, you can easily add or remove profiles as needed.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20230508-biometrics-2.png)

Once multiple profiles are setup, you will see a new option in the sidebar to quickly toggle from one profile to another:

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20230508-biometrics-3.png)

Once you've set up multiple profiles, you can easily toggle between them using the new option in the sidebar. This feature is perfect for separating your personal and work notes into independent collections.

## Support for realtime search

Our mobile app now has an improved search function that performs text searches in real time! No more waiting for the search results to load, they'll appear instantly as you type.

## Improved filesystem sync performance

Thanks to the hard work of jd1378, the sync no longer freezes during filesystem synchronisation. We know how frustrating that can be, and we're thrilled to have solved this issue. Getting filesystem sync to work on Android is never easy due to the restrictions put in place by Google, especially since they frequently change, but we're committed to delivering the best possible experience for our Android users.