/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.util.ConnectionUtil;
import com.jsql.util.LogLevelUtil;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CallableHttpHead
implements Callable<CallableHttpHead> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final String urlAdminPage;
    private String responseCodeHttp = "";
    private final InjectionModel injectionModel;
    private final String metadataInjectionProcess;

    public CallableHttpHead(String urlAdminPage, InjectionModel injectionModel, String metadataInjectionProcess) {
        this.urlAdminPage = urlAdminPage;
        this.injectionModel = injectionModel;
        this.metadataInjectionProcess = metadataInjectionProcess;
    }

    @Override
    public CallableHttpHead call() {
        if (this.injectionModel.getResourceAccess().isSearchAdminStopped()) {
            return this;
        }
        try {
            HttpRequest.Builder builderHttpRequest = HttpRequest.newBuilder().uri(URI.create(this.urlAdminPage)).method("HEAD", HttpRequest.BodyPublishers.noBody()).timeout(Duration.ofSeconds(4L));
            Stream.of(this.injectionModel.getMediatorUtils().getParameterUtil().getHeaderFromEntries().split("\\\\r\\\\n")).map(e -> {
                if (e.split(":").length == 2) {
                    return new AbstractMap.SimpleEntry<String, String>(e.split(":")[0], e.split(":")[1]);
                }
                return null;
            }).filter(Objects::nonNull).forEach(e -> builderHttpRequest.header((String)e.getKey(), (String)e.getValue()));
            HttpRequest httpRequest = builderHttpRequest.build();
            HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(4L)).build();
            HttpResponse<Void> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.discarding());
            this.responseCodeHttp = "" + response.statusCode();
            EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
            msgHeader.put(Header.URL, this.urlAdminPage);
            msgHeader.put(Header.POST, "");
            msgHeader.put(Header.HEADER, ConnectionUtil.getHeadersMap(httpRequest.headers()));
            msgHeader.put(Header.RESPONSE, ConnectionUtil.getHeadersMap(response));
            msgHeader.put(Header.METADATA_PROCESS, this.metadataInjectionProcess);
            Request request = new Request();
            request.setMessage(Interaction.MESSAGE_HEADER);
            request.setParameters(msgHeader);
            this.injectionModel.sendToViews(request);
        }
        catch (InterruptedException e2) {
            LOGGER.log(LogLevelUtil.IGNORE, e2, (Throwable)e2);
            Thread.currentThread().interrupt();
        }
        catch (Exception e3) {
            String eMessageImplicit = String.format("Problem connecting to %s (implicit reason): %s", this.urlAdminPage, InjectionModel.getImplicitReason(e3));
            String eMessage = Optional.ofNullable(e3.getMessage()).orElse(eMessageImplicit);
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, eMessage);
        }
        return this;
    }

    public boolean isHttpResponseOk() {
        return this.responseCodeHttp.matches("[23]\\d\\d");
    }

    public String getUrl() {
        return this.urlAdminPage;
    }
}

