/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.method;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.util.JsonUtil;
import com.jsql.util.LogLevelUtil;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.json.JSONException;

public abstract class AbstractMethodInjection
implements Serializable {
    private static final Logger LOGGER = LogManager.getRootLogger();
    protected final InjectionModel injectionModel;

    protected AbstractMethodInjection(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public abstract boolean isCheckingAllParam();

    public abstract String getParamsAsString();

    public abstract List<AbstractMap.SimpleEntry<String, String>> getParams();

    public abstract String name();

    public boolean testParameters() throws JSqlException {
        boolean hasFoundInjection = false;
        if (!this.injectionModel.getMediatorUtils().getPreferencesUtil().isCheckingAllParam() && this.injectionModel.getMediatorUtils().getConnectionUtil().getMethodInjection() != this) {
            return false;
        }
        this.injectionModel.getMediatorUtils().getConnectionUtil().setMethodInjection(this);
        hasFoundInjection = this.getParamsAsString().contains("*") || this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase().contains("*") ? this.checkParamWithStar() : (!this.isCheckingAllParam() ? this.checkLastParam() : this.checkAllParams());
        return hasFoundInjection;
    }

    private boolean checkParamWithStar() throws JSqlException {
        return this.injectionModel.getMediatorStrategy().testStrategies(null);
    }

    private boolean checkLastParam() throws JSqlException {
        AbstractMap.SimpleEntry parameterToInject = (AbstractMap.SimpleEntry)this.getParams().stream().reduce((a, b) -> b).orElseThrow(NullPointerException::new);
        return this.injectionModel.getMediatorStrategy().testStrategies(parameterToInject);
    }

    private boolean checkAllParams() throws StoppedByUserSlidingException {
        for (AbstractMap.SimpleEntry<String, String> paramBase : this.getParams()) {
            for (AbstractMap.SimpleEntry<String, String> paramStar : this.getParams()) {
                if (paramStar != paramBase) continue;
                try {
                    if (!this.isParamInjectable(paramStar)) continue;
                    return true;
                }
                catch (JSONException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
                }
            }
        }
        return false;
    }

    private boolean isParamInjectable(AbstractMap.SimpleEntry<String, String> paramStar) throws StoppedByUserSlidingException {
        Object jsonEntity = JsonUtil.getJson(paramStar.getValue());
        List<AbstractMap.SimpleEntry<String, String>> attributesJson = JsonUtil.createEntries(jsonEntity, "root", null);
        boolean hasFoundInjection = this.injectionModel.getMediatorUtils().getPreferencesUtil().isCheckingAllJsonParam() && !attributesJson.isEmpty() ? this.injectionModel.getMediatorUtils().getJsonUtil().testJsonParam(this, paramStar) : this.testJsonlessParam(paramStar);
        return hasFoundInjection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testJsonlessParam(AbstractMap.SimpleEntry<String, String> paramStar) throws StoppedByUserSlidingException {
        boolean hasFoundInjection = false;
        paramStar.setValue(paramStar.getValue() + "*");
        try {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = this::name;
            supplierArray[1] = paramStar::getKey;
            supplierArray[2] = () -> ((String)paramStar.getValue()).replace("*", "");
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Checking {} parameter {}={}", supplierArray);
            hasFoundInjection = this.injectionModel.getMediatorStrategy().testStrategies(paramStar);
        }
        catch (StoppedByUserSlidingException e2) {
            throw e2;
        }
        catch (JSqlException e3) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "No {} injection found for parameter {}={} ({})", (Object)this.name(), (Object)paramStar.getKey(), (Object)paramStar.getValue().replaceAll("\\+.?$|\\*", ""), (Object)e3.getMessage());
        }
        finally {
            if (!hasFoundInjection) {
                this.getParams().forEach(e -> e.setValue(((String)e.getValue()).replaceAll(Pattern.quote("*") + "$", "")));
                paramStar.setValue(paramStar.getValue().replace("*", ""));
            }
        }
        return hasFoundInjection;
    }
}

