/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.injection.strategy.StrategyInjectionBlind;
import com.jsql.model.injection.strategy.StrategyInjectionError;
import com.jsql.model.injection.strategy.StrategyInjectionMultibit;
import com.jsql.model.injection.strategy.StrategyInjectionNormal;
import com.jsql.model.injection.strategy.StrategyInjectionStacked;
import com.jsql.model.injection.strategy.StrategyInjectionTime;
import com.jsql.model.suspendable.SuspendableGetCharInsertion;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediatorStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final AbstractStrategy time;
    private final AbstractStrategy blind;
    private final AbstractStrategy multibit;
    private final StrategyInjectionError error;
    private final AbstractStrategy normal;
    private final AbstractStrategy stacked;
    private final List<AbstractStrategy> strategies;
    private AbstractStrategy strategy;
    private final InjectionModel injectionModel;

    public MediatorStrategy(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        this.time = new StrategyInjectionTime(this.injectionModel);
        this.blind = new StrategyInjectionBlind(this.injectionModel);
        this.multibit = new StrategyInjectionMultibit(this.injectionModel);
        this.error = new StrategyInjectionError(this.injectionModel);
        this.normal = new StrategyInjectionNormal(this.injectionModel);
        this.stacked = new StrategyInjectionStacked(this.injectionModel);
        this.strategies = Arrays.asList(this.time, this.blind, this.multibit, this.error, this.stacked, this.normal);
    }

    public String getMeta() {
        String strategyName = this.strategy == null ? "" : this.strategy.toString().toLowerCase();
        String strategyMode = "default";
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isDiosStrategy()) {
            strategyMode = "dios";
        } else if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isZipStrategy()) {
            strategyMode = "zip";
        }
        return String.format("%s#%s", strategyName, strategyMode);
    }

    public String buildURL(String urlBase, boolean isUsingIndex, String sqlTrail) {
        String result = urlBase;
        if (urlBase.contains("*")) {
            result = !isUsingIndex ? urlBase.replace("*", this.extracted(sqlTrail)) : urlBase.replace("*", this.extracted(this.injectionModel.getIndexesInUrl().replaceAll("1337" + this.normal.getVisibleIndex() + "7331", Matcher.quoteReplacement(sqlTrail))));
        }
        return result;
    }

    private String extracted(String sqlTrail) {
        return StringUtil.clean(sqlTrail).replace("\"", "%22").replace("'", "%27").replace("(", "%28").replace(")", "%29").replace("{", "%7B").replace("[", "%5B").replace("|", "%7C").replace("`", "%60").replace("]", "%5D").replace("}", "%7D").replace(">", "%3E").replace("<", "%3C").replace("?", "%3F").replace("_", "%5F").replace("\\", "%5C").replace(",", "%2C").replace(" ", "%20").replace("+", "%20") + this.injectionModel.getMediatorVendor().getVendor().instance().endingComment().replace("+", "%20");
    }

    public boolean testStrategies(AbstractMap.SimpleEntry<String, String> parameterToInject) throws JSqlException {
        String parameterOriginalValue = null;
        this.injectionModel.getMediatorVendor().setVendor(this.injectionModel.getMediatorVendor().fingerprintVendor());
        if (parameterToInject != null) {
            parameterOriginalValue = parameterToInject.getValue();
            String characterInsertionByUser = this.injectionModel.getMediatorUtils().getParameterUtil().initializeStar(parameterToInject);
            String characterInsertion = new SuspendableGetCharInsertion(this.injectionModel).run(characterInsertionByUser);
            if (characterInsertion.contains("*")) {
                parameterToInject.setValue(characterInsertion);
            } else {
                parameterToInject.setValue(characterInsertion + "+*");
            }
        }
        this.time.checkApplicability();
        this.blind.checkApplicability();
        if (parameterToInject != null) {
            String backupCharacterInsertion = parameterToInject.getValue();
            parameterToInject.setValue("*");
            this.multibit.checkApplicability();
            parameterToInject.setValue(backupCharacterInsertion);
        } else {
            this.multibit.checkApplicability();
        }
        this.error.checkApplicability();
        this.stacked.checkApplicability();
        this.normal.checkApplicability();
        if (this.normal.isApplicable()) {
            this.normal.activateStrategy();
        } else if (this.stacked.isApplicable()) {
            this.stacked.activateStrategy();
        } else if (this.error.isApplicable()) {
            this.error.activateStrategy();
        } else if (this.multibit.isApplicable()) {
            this.multibit.activateStrategy();
        } else if (this.blind.isApplicable()) {
            this.blind.activateStrategy();
        } else if (this.time.isApplicable()) {
            this.time.activateStrategy();
        } else {
            if (parameterOriginalValue != null) {
                parameterToInject.setValue(parameterOriginalValue.replace("*", ""));
            }
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "No injection found");
            return false;
        }
        return true;
    }

    public AbstractStrategy getNormal() {
        return this.normal;
    }

    public StrategyInjectionError getError() {
        return this.error;
    }

    public AbstractStrategy getBlind() {
        return this.blind;
    }

    public AbstractStrategy getMultibit() {
        return this.multibit;
    }

    public AbstractStrategy getTime() {
        return this.time;
    }

    public AbstractStrategy getStacked() {
        return this.stacked;
    }

    public List<AbstractStrategy> getStrategies() {
        return this.strategies;
    }

    public AbstractStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(AbstractStrategy strategy) {
        this.strategy = strategy;
    }
}

