/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.injection.vendor.model.VendorYaml;
import com.jsql.model.injection.vendor.model.yaml.Configuration;
import com.jsql.model.injection.vendor.model.yaml.Strategy;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrategyInjectionStacked
extends AbstractStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String performanceLength = "0";

    public StrategyInjectionStacked(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public void checkApplicability() {
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isStrategyStackedDisabled()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Skipping strategy Stacked disabled");
            return;
        }
        this.isApplicable = false;
        Strategy strategyYaml = this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getStrategy();
        Configuration configurationYaml = strategyYaml.getConfiguration();
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} Stacked...", () -> I18nUtil.valueByKey("LOG_CHECKING_STRATEGY"));
        boolean methodIsApplicable = this.isApplicable(configurationYaml, strategyYaml.getStacked());
        if (methodIsApplicable) {
            Matcher regexSearch = this.getPerformance(configurationYaml, strategyYaml.getStacked());
            if (!regexSearch.find()) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "{} {} but injectable size is incorrect", () -> I18nUtil.valueByKey("LOG_VULNERABLE"), () -> "Stacked");
                methodIsApplicable = false;
            } else {
                this.performanceLength = "" + regexSearch.group(1).length();
            }
        }
        if (methodIsApplicable) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} Stacked injection using [{}] characters", () -> I18nUtil.valueByKey("LOG_VULNERABLE"), () -> this.performanceLength);
            this.allow(new int[0]);
        } else {
            this.unallow(new int[0]);
        }
    }

    private boolean isApplicable(Configuration configurationYaml, String stacked) {
        boolean methodIsApplicable = false;
        String performanceSourcePage = this.injectionModel.injectWithoutIndex(" " + VendorYaml.replaceTags(stacked.replace("${window}", configurationYaml.getSlidingWindow()).replace("${injection}", configurationYaml.getFailsafe().replace("${indice}", "0")).replace("${window.char}", "1").replace("${capacity}", "65565")), "stacked#confirm");
        if (performanceSourcePage.matches("(?s).*133707331.*")) {
            methodIsApplicable = true;
            this.isApplicable = true;
        }
        return methodIsApplicable;
    }

    private Matcher getPerformance(Configuration configurationYaml, String stacked) {
        String performanceSourcePage = this.injectionModel.injectWithoutIndex(" " + VendorYaml.replaceTags(stacked.replace("${window}", configurationYaml.getSlidingWindow()).replace("${injection}", configurationYaml.getCalibrator()).replace("${window.char}", "1").replace("${capacity}", "65565")), "stacked#size");
        return Pattern.compile("(?s)SqLi(#+)").matcher(performanceSourcePage);
    }

    @Override
    public void allow(int ... i) {
        this.markVulnerability(Interaction.MARK_STACKED_VULNERABLE, new int[0]);
    }

    @Override
    public void unallow(int ... i) {
        this.markVulnerability(Interaction.MARK_STACKED_INVULNERABLE, new int[0]);
    }

    @Override
    public String inject(String sqlQuery, String startPosition, AbstractSuspendable stoppable, String metadataInjectionProcess) {
        return this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlStacked(sqlQuery, startPosition), metadataInjectionProcess);
    }

    @Override
    public void activateStrategy() {
        LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} [{}]", () -> I18nUtil.valueByKey("LOG_USING_STRATEGY"), this::getName);
        this.injectionModel.getMediatorStrategy().setStrategy(this.injectionModel.getMediatorStrategy().getStacked());
        Request request = new Request();
        request.setMessage(Interaction.MARK_STACKED_STRATEGY);
        this.injectionModel.sendToViews(request);
    }

    @Override
    public String getPerformanceLength() {
        return this.performanceLength;
    }

    @Override
    public String getName() {
        return "Stacked";
    }
}

