/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractCallableBoolean;
import com.jsql.model.injection.strategy.blind.CallableCharInsertion;
import com.jsql.model.injection.strategy.blind.patch.Diff;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionCharInsertion {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String blankFalseMark;
    private List<Diff> constantTrueMark = new ArrayList<Diff>();
    protected final InjectionModel injectionModel;
    private final String prefixSuffix;
    private static final String PREFIX = "prefix";
    private final List<String> falseTest;

    public InjectionCharInsertion(InjectionModel injectionModel, String falseCharInsertion, String prefixSuffix) {
        this.injectionModel = injectionModel;
        this.prefixSuffix = prefixSuffix;
        List<String> trueTest = this.injectionModel.getMediatorVendor().getVendor().instance().getListTrueTest();
        this.falseTest = this.injectionModel.getMediatorVendor().getVendor().instance().getListFalseTest();
        if (trueTest.isEmpty() || this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.blankFalseMark = this.callUrl(String.join((CharSequence)"+", falseCharInsertion, this.injectionModel.getMediatorVendor().getVendor().instance().endingComment(), "fals+"), "prefix#ref");
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableCharInsertionTagTrue");
        ArrayList<CallableCharInsertion> listCallableTagTrue = new ArrayList<CallableCharInsertion>();
        for (String urlTest : trueTest) {
            listCallableTagTrue.add(new CallableCharInsertion(String.join((CharSequence)"+", prefixSuffix.replace(PREFIX, RandomStringUtils.random(10, "345")), this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getStrategy().getBoolean().getModeOr(), urlTest), this, "prefix#true"));
        }
        try {
            List listTagTrue = taskExecutor.invokeAll(listCallableTagTrue);
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
            for (int i = 1; i < listTagTrue.size(); ++i) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (this.constantTrueMark.isEmpty()) {
                    this.constantTrueMark = ((CallableCharInsertion)listTagTrue.get(i).get()).getOpcodes();
                    continue;
                }
                this.constantTrueMark.retainAll(((CallableCharInsertion)listTagTrue.get(i).get()).getOpcodes());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.initializeFalseMarks();
    }

    private void initializeFalseMarks() {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetBlindTagTrue");
        ArrayList<CallableCharInsertion> listCallableTagFalse = new ArrayList<CallableCharInsertion>();
        for (String urlTest : this.falseTest) {
            listCallableTagFalse.add(new CallableCharInsertion(String.join((CharSequence)"+", this.prefixSuffix.replace(PREFIX, RandomStringUtils.random(10, "345")), this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getStrategy().getBoolean().getModeOr(), urlTest), this, "prefix#false"));
        }
        try {
            List listTagFalse = taskExecutor.invokeAll(listCallableTagFalse);
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
            for (Future falseTag : listTagFalse) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                this.constantTrueMark.removeAll(((CallableCharInsertion)falseTag.get()).getOpcodes());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public boolean isInjectable() throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableCharInsertion blindTest = new CallableCharInsertion(String.join((CharSequence)"+", this.prefixSuffix.replace(PREFIX, RandomStringUtils.random(10, "678")), this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getStrategy().getBoolean().getModeOr(), this.injectionModel.getMediatorVendor().getVendor().instance().sqlTestBooleanInitialization()), this, "prefix#confirm");
        try {
            blindTest.call();
        }
        catch (Exception e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return blindTest.isTrue() && !this.constantTrueMark.isEmpty();
    }

    public String callUrl(String urlString, String metadataInjectionProcess) {
        return this.injectionModel.injectWithoutIndex(urlString, metadataInjectionProcess);
    }

    public String callUrl(String urlString, String metadataInjectionProcess, AbstractCallableBoolean<?> callableBoolean) {
        return this.injectionModel.injectWithoutIndex(urlString, metadataInjectionProcess, callableBoolean);
    }

    public String getBlankFalseMark() {
        return this.blankFalseMark;
    }

    public List<Diff> getConstantTrueMark() {
        return this.constantTrueMark;
    }
}

