/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBoolean;
import com.jsql.model.injection.strategy.blind.CallableMultibit;
import com.jsql.model.injection.strategy.blind.patch.Diff;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionMultibit
extends AbstractInjectionBoolean<CallableMultibit> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String sourceReference;
    private List<Diff> diffsCommonWithAllIds = new ArrayList<Diff>();
    private final List<List<Diff>> diffsById = new ArrayList<List<Diff>>();

    public InjectionMultibit(InjectionModel injectionModel, AbstractInjectionBoolean.BooleanMode blindMode) {
        super(injectionModel, blindMode);
        if (this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.sourceReference = this.callUrl("8", "multibit#ref");
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetMultibitIds");
        ArrayList<CallableMultibit> callablesId = new ArrayList<CallableMultibit>();
        for (int i = 0; i < 8; ++i) {
            callablesId.add(new CallableMultibit("" + i, this, "multibit#ref~" + i));
        }
        try {
            List futuresId = taskExecutor.invokeAll(callablesId);
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
            for (Future future : futuresId) {
                List<Diff> diffsWithReference = ((CallableMultibit)future.get()).getDiffsWithReference();
                if (this.diffsCommonWithAllIds.isEmpty()) {
                    this.diffsCommonWithAllIds = new ArrayList<Diff>(diffsWithReference);
                } else {
                    this.diffsCommonWithAllIds.retainAll(diffsWithReference);
                }
                this.diffsById.add(diffsWithReference);
            }
            for (List list : this.diffsById) {
                list.removeAll(this.diffsCommonWithAllIds);
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public CallableMultibit getCallableTest(String sqlQuery, int indexCharacter, int block) {
        return new CallableMultibit(sqlQuery, indexCharacter, block, this.injectionModel, this, "multi#" + indexCharacter + "." + block);
    }

    @Override
    public boolean isInjectable() throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableMultibit callableBlock1 = new CallableMultibit("'a'", 1, 1, this.injectionModel, this, "multi#confirm.1");
        CallableMultibit callableBlock2 = new CallableMultibit("'a'", 1, 2, this.injectionModel, this, "multi#confirm.2");
        CallableMultibit callableBlock3 = new CallableMultibit("'a'", 1, 3, this.injectionModel, this, "multi#confirm.3");
        callableBlock1.call();
        callableBlock2.call();
        callableBlock3.call();
        return callableBlock1.getIdPage() == 3 && callableBlock2.getIdPage() == 0 && callableBlock3.getIdPage() == 1;
    }

    @Override
    public String getInfoMessage() {
        return "- Strategy Multibit: query 3 bits when Diffs match index in " + this.diffsById + "\n\n";
    }

    @Override
    public void initializeNextCharacters(String sqlQuery, List<char[]> bytes, AtomicInteger indexCharacter, CompletionService<CallableMultibit> taskCompletionService, AtomicInteger countTasksSubmitted) {
        indexCharacter.incrementAndGet();
        bytes.add(new char[]{'0', 'x', 'x', 'x', 'x', 'x', 'x', 'x'});
        for (int block : new int[]{1, 2, 3}) {
            taskCompletionService.submit(this.getCallableTest(sqlQuery, indexCharacter.get(), block));
            countTasksSubmitted.addAndGet(1);
        }
    }

    @Override
    public char[] initializeBinaryMask(List<char[]> bytes, CallableMultibit currentCallable) {
        char[] asciiCodeMask = bytes.get(currentCallable.getCurrentIndex() - 1);
        this.extractBitsFromBlock(currentCallable, asciiCodeMask);
        return asciiCodeMask;
    }

    private void extractBitsFromBlock(CallableMultibit currentCallable, char[] bits) {
        if (currentCallable.block == 1) {
            this.convertIdPageToBits(currentCallable, bits, 0, 1, 2);
        } else if (currentCallable.block == 2) {
            this.convertIdPageToBits(currentCallable, bits, 3, 4, 5);
        } else if (currentCallable.block == 3) {
            this.convertIdPageToBits(currentCallable, bits, -1, 6, 7);
        }
    }

    private void convertIdPageToBits(CallableMultibit callable, char[] bits, int i1, int i2, int i3) {
        if (callable.idPage == 0) {
            if (i1 > -1) {
                bits[i1] = 48;
            }
            bits[i2] = 48;
            bits[i3] = 48;
        } else if (callable.idPage == 1) {
            if (i1 > -1) {
                bits[i1] = 48;
            }
            bits[i2] = 48;
            bits[i3] = 49;
        } else if (callable.idPage == 2) {
            if (i1 > -1) {
                bits[i1] = 48;
            }
            bits[i2] = 49;
            bits[i3] = 48;
        } else if (callable.idPage == 3) {
            if (i1 > -1) {
                bits[i1] = 48;
            }
            bits[i2] = 49;
            bits[i3] = 49;
        } else if (callable.idPage == 4) {
            if (i1 > -1) {
                bits[i1] = 49;
            }
            bits[i2] = 48;
            bits[i3] = 48;
        } else if (callable.idPage == 5) {
            if (i1 > -1) {
                bits[i1] = 49;
            }
            bits[i2] = 48;
            bits[i3] = 49;
        } else if (callable.idPage == 6) {
            if (i1 > -1) {
                bits[i1] = 49;
            }
            bits[i2] = 49;
            bits[i3] = 48;
        } else if (callable.idPage == 7) {
            if (i1 > -1) {
                bits[i1] = 49;
            }
            bits[i2] = 49;
            bits[i3] = 49;
        }
    }

    public String getSourceReference() {
        return this.sourceReference;
    }

    public List<Diff> getDiffsCommonWithAllIds() {
        return this.diffsCommonWithAllIds;
    }

    public List<List<Diff>> getDiffsById() {
        return this.diffsById;
    }
}

