/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind.patch;

import com.jsql.model.injection.strategy.blind.patch.Diff;
import com.jsql.model.injection.strategy.blind.patch.Patch;
import com.jsql.util.LogLevelUtil;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiffMatchPatch {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final float DIFF_TIMEOUT = 1.0f;
    public static final short DIFF_EDIT_COST = 4;
    public static final float MATCH_THRESHOLD = 0.5f;
    public static final int MATCH_DISTANCE = 1000;
    public static final float PATCH_DELETE_THRESHOLD = 0.5f;
    public static final short PATCH_MARGIN = 4;
    private static final short MATCH_MAX_BITS = 32;
    private static final Pattern BLANK_LINE_END = Pattern.compile("\\n\\r?\\n\\Z", 32);
    private static final Pattern BLANK_LINE_START = Pattern.compile("\\A\\r?\\n\\r?\\n", 32);

    public List<Diff> diffMain(String text1, String text2) {
        return this.diffMain(text1, text2, true);
    }

    public LinkedList<Diff> diffMain(String text1, String text2, boolean checklines) {
        long deadline = System.currentTimeMillis() + 1000L;
        return this.diffMain(text1, text2, checklines, deadline);
    }

    private LinkedList<Diff> diffMain(String valueText1, String valueText2, boolean checklines, long deadline) {
        String text1 = valueText1;
        String text2 = valueText2;
        if (text1 == null || text2 == null) {
            throw new IllegalArgumentException("Null inputs. (diff_main)");
        }
        if (text1.equals(text2)) {
            LinkedList<Diff> diffs = new LinkedList<Diff>();
            if (text1.length() != 0) {
                diffs.add(new Diff(Operation.EQUAL, text1));
            }
            return diffs;
        }
        int commonlength = this.diffCommonPrefix(text1, text2);
        String commonprefix = text1.substring(0, commonlength);
        text1 = text1.substring(commonlength);
        text2 = text2.substring(commonlength);
        commonlength = this.diffCommonSuffix(text1, text2);
        String commonsuffix = text1.substring(text1.length() - commonlength);
        text1 = text1.substring(0, text1.length() - commonlength);
        text2 = text2.substring(0, text2.length() - commonlength);
        LinkedList<Diff> diffs = this.diffCompute(text1, text2, checklines, deadline);
        if (commonprefix.length() != 0) {
            diffs.addFirst(new Diff(Operation.EQUAL, commonprefix));
        }
        if (commonsuffix.length() != 0) {
            diffs.addLast(new Diff(Operation.EQUAL, commonsuffix));
        }
        this.diffCleanupMerge(diffs);
        return diffs;
    }

    private LinkedList<Diff> diffCompute(String text1, String text2, boolean checklines, long deadline) {
        String shorttext;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        if (text1.length() == 0) {
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        if (text2.length() == 0) {
            diffs.add(new Diff(Operation.DELETE, text1));
            return diffs;
        }
        String longtext = text1.length() > text2.length() ? text1 : text2;
        int i = longtext.indexOf(shorttext = text1.length() > text2.length() ? text2 : text1);
        if (i != -1) {
            Operation op = text1.length() > text2.length() ? Operation.DELETE : Operation.INSERT;
            diffs.add(new Diff(op, longtext.substring(0, i)));
            diffs.add(new Diff(Operation.EQUAL, shorttext));
            diffs.add(new Diff(op, longtext.substring(i + shorttext.length())));
            return diffs;
        }
        if (shorttext.length() == 1) {
            diffs.add(new Diff(Operation.DELETE, text1));
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        String[] hm = this.diffHalfMatch(text1, text2);
        if (hm != null) {
            String text1A = hm[0];
            String text1B = hm[1];
            String text2A = hm[2];
            String text2B = hm[3];
            String midCommon = hm[4];
            LinkedList<Diff> diffsA = this.diffMain(text1A, text2A, checklines, deadline);
            LinkedList<Diff> diffsB = this.diffMain(text1B, text2B, checklines, deadline);
            diffs = diffsA;
            diffs.add(new Diff(Operation.EQUAL, midCommon));
            diffs.addAll(diffsB);
            return diffs;
        }
        if (checklines && text1.length() > 100 && text2.length() > 100) {
            return this.diffLineMode(text1, text2, deadline);
        }
        return this.diffBisect(text1, text2, deadline);
    }

    private LinkedList<Diff> diffLineMode(String valueText1, String valueText2, long deadline) {
        LinesToCharsResult b = this.diffLinesToChars(valueText1, valueText2);
        String text1 = b.chars1;
        String text2 = b.chars2;
        List<String> linearray = b.lineArray;
        LinkedList<Diff> diffs = this.diffMain(text1, text2, false, deadline);
        this.diffCharsToLines(diffs, linearray);
        this.diffCleanupSemantic(diffs);
        diffs.add(new Diff(Operation.EQUAL, ""));
        int countDelete = 0;
        int countInsert = 0;
        StringBuilder textDelete = new StringBuilder();
        StringBuilder textInsert = new StringBuilder();
        ListIterator<Diff> pointer = diffs.listIterator();
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            switch (thisDiff.getOperation()) {
                case INSERT: {
                    ++countInsert;
                    textInsert.append(thisDiff.getText());
                    break;
                }
                case DELETE: {
                    ++countDelete;
                    textDelete.append(thisDiff.getText());
                    break;
                }
                case EQUAL: {
                    if (countDelete >= 1 && countInsert >= 1) {
                        pointer.previous();
                        for (int j = 0; j < countDelete + countInsert; ++j) {
                            pointer.previous();
                            pointer.remove();
                        }
                        for (Diff newDiff : this.diffMain(textDelete.toString(), textInsert.toString(), false, deadline)) {
                            pointer.add(newDiff);
                        }
                    }
                    countInsert = 0;
                    countDelete = 0;
                    textDelete.setLength(0);
                    textInsert.setLength(0);
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        diffs.removeLast();
        return diffs;
    }

    protected LinkedList<Diff> diffBisect(String text1, String text2, long deadline) {
        int maxD;
        int text1Length = text1.length();
        int text2Length = text2.length();
        int vOffset = maxD = (text1Length + text2Length + 1) / 2;
        int vLength = 2 * maxD;
        int[] v1 = new int[vLength];
        int[] v2 = new int[vLength];
        for (int x = 0; x < vLength; ++x) {
            v1[x] = -1;
            v2[x] = -1;
        }
        v1[vOffset + 1] = 0;
        v2[vOffset + 1] = 0;
        int delta = text1Length - text2Length;
        boolean front = delta % 2 != 0;
        int k1start = 0;
        int k1end = 0;
        int k2start = 0;
        int k2end = 0;
        for (int d = 0; d < maxD && System.currentTimeMillis() <= deadline; ++d) {
            for (int k1 = -d + k1start; k1 <= d - k1end; k1 += 2) {
                int x2;
                int k2Offset;
                int y1;
                int k1Offset = vOffset + k1;
                int x1 = k1 == -d || k1 != d && v1[k1Offset - 1] < v1[k1Offset + 1] ? v1[k1Offset + 1] : v1[k1Offset - 1] + 1;
                for (y1 = x1 - k1; x1 < text1Length && y1 < text2Length && text1.charAt(x1) == text2.charAt(y1); ++x1, ++y1) {
                }
                v1[k1Offset] = x1;
                if (x1 > text1Length) {
                    k1end += 2;
                    continue;
                }
                if (y1 > text2Length) {
                    k1start += 2;
                    continue;
                }
                if (!front || (k2Offset = vOffset + delta - k1) < 0 || k2Offset >= vLength || v2[k2Offset] == -1 || x1 < (x2 = text1Length - v2[k2Offset])) continue;
                return this.diffBisectSplit(text1, text2, x1, y1, deadline);
            }
            for (int k2 = -d + k2start; k2 <= d - k2end; k2 += 2) {
                int k1Offset;
                int y2;
                int k2Offset = vOffset + k2;
                int x2 = k2 == -d || k2 != d && v2[k2Offset - 1] < v2[k2Offset + 1] ? v2[k2Offset + 1] : v2[k2Offset - 1] + 1;
                for (y2 = x2 - k2; x2 < text1Length && y2 < text2Length && text1.charAt(text1Length - x2 - 1) == text2.charAt(text2Length - y2 - 1); ++x2, ++y2) {
                }
                v2[k2Offset] = x2;
                if (x2 > text1Length) {
                    k2end += 2;
                    continue;
                }
                if (y2 > text2Length) {
                    k2start += 2;
                    continue;
                }
                if (front || (k1Offset = vOffset + delta - k2) < 0 || k1Offset >= vLength || v1[k1Offset] == -1) continue;
                int x1 = v1[k1Offset];
                int y1 = vOffset + x1 - k1Offset;
                if (x1 < (x2 = text1Length - x2)) continue;
                return this.diffBisectSplit(text1, text2, x1, y1, deadline);
            }
        }
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        diffs.add(new Diff(Operation.DELETE, text1));
        diffs.add(new Diff(Operation.INSERT, text2));
        return diffs;
    }

    private LinkedList<Diff> diffBisectSplit(String text1, String text2, int x, int y, long deadline) {
        String text1a = text1.substring(0, x);
        String text2a = text2.substring(0, y);
        String text1b = text1.substring(x);
        String text2b = text2.substring(y);
        LinkedList<Diff> diffs = this.diffMain(text1a, text2a, false, deadline);
        LinkedList<Diff> diffsb = this.diffMain(text1b, text2b, false, deadline);
        diffs.addAll(diffsb);
        return diffs;
    }

    protected LinesToCharsResult diffLinesToChars(String text1, String text2) {
        ArrayList<String> lineArray = new ArrayList<String>();
        HashMap<String, Integer> lineHash = new HashMap<String, Integer>();
        lineArray.add("");
        String chars1 = this.diffLinesToCharsMunge(text1, lineArray, lineHash);
        String chars2 = this.diffLinesToCharsMunge(text2, lineArray, lineHash);
        return new LinesToCharsResult(chars1, chars2, lineArray);
    }

    private String diffLinesToCharsMunge(String text, List<String> lineArray, Map<String, Integer> lineHash) {
        int lineStart = 0;
        int lineEnd = -1;
        StringBuilder chars = new StringBuilder();
        while (lineEnd < text.length() - 1) {
            lineEnd = text.indexOf(10, lineStart);
            if (lineEnd == -1) {
                lineEnd = text.length() - 1;
            }
            String line = text.substring(lineStart, lineEnd + 1);
            lineStart = lineEnd + 1;
            if (lineHash.containsKey(line)) {
                chars.append(String.valueOf((char)lineHash.get(line).intValue()));
                continue;
            }
            lineArray.add(line);
            lineHash.put(line, lineArray.size() - 1);
            chars.append(String.valueOf((char)(lineArray.size() - 1)));
        }
        return chars.toString();
    }

    protected void diffCharsToLines(List<Diff> diffs, List<String> lineArray) {
        for (Diff diff : diffs) {
            StringBuilder text = new StringBuilder();
            for (int y = 0; y < diff.getText().length(); ++y) {
                text.append(lineArray.get(diff.getText().charAt(y)));
            }
            diff.setText(text.toString());
        }
    }

    public int diffCommonPrefix(String text1, String text2) {
        int n = Math.min(text1.length(), text2.length());
        for (int i = 0; i < n; ++i) {
            if (text1.charAt(i) == text2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public int diffCommonSuffix(String text1, String text2) {
        int text1Length = text1.length();
        int text2Length = text2.length();
        int n = Math.min(text1Length, text2Length);
        for (int i = 1; i <= n; ++i) {
            if (text1.charAt(text1Length - i) == text2.charAt(text2Length - i)) continue;
            return i - 1;
        }
        return n;
    }

    protected int diffCommonOverlap(String valueText1, String valueText2) {
        String text1 = valueText1;
        String text2 = valueText2;
        int text1Length = text1.length();
        int text2Length = text2.length();
        if (text1Length == 0 || text2Length == 0) {
            return 0;
        }
        if (text1Length > text2Length) {
            text1 = text1.substring(text1Length - text2Length);
        } else if (text1Length < text2Length) {
            text2 = text2.substring(0, text1Length);
        }
        int textLength = Math.min(text1Length, text2Length);
        if (text1.equals(text2)) {
            return textLength;
        }
        int best = 0;
        int length = 1;
        String pattern;
        int found;
        while ((found = text2.indexOf(pattern = text1.substring(textLength - length))) != -1) {
            if (found != 0 && !text1.substring(textLength - (length += found)).equals(text2.substring(0, length))) continue;
            best = length++;
        }
        return best;
    }

    protected String[] diffHalfMatch(String text1, String text2) {
        String[] hm;
        String shorttext;
        String longtext = text1.length() > text2.length() ? text1 : text2;
        String string = shorttext = text1.length() > text2.length() ? text2 : text1;
        if (longtext.length() < 4 || shorttext.length() * 2 < longtext.length()) {
            return null;
        }
        String[] hm1 = this.diffHalfMatchI(longtext, shorttext, (longtext.length() + 3) / 4);
        String[] hm2 = this.diffHalfMatchI(longtext, shorttext, (longtext.length() + 1) / 2);
        if (hm1 == null && hm2 == null) {
            return null;
        }
        if (hm2 == null) {
            hm = hm1;
        } else if (hm1 == null) {
            hm = hm2;
        } else {
            String[] stringArray = hm = hm1[4].length() > hm2[4].length() ? hm1 : hm2;
        }
        if (text1.length() > text2.length()) {
            return hm;
        }
        return new String[]{hm[2], hm[3], hm[0], hm[1], hm[4]};
    }

    private String[] diffHalfMatchI(String longtext, String shorttext, int i) {
        String seed = longtext.substring(i, i + longtext.length() / 4);
        int j = -1;
        Object bestCommon = "";
        String bestLongtextA = "";
        String bestLongtextB = "";
        String bestShorttextA = "";
        String bestShorttextB = "";
        while ((j = shorttext.indexOf(seed, j + 1)) != -1) {
            int prefixLength = this.diffCommonPrefix(longtext.substring(i), shorttext.substring(j));
            int suffixLength = this.diffCommonSuffix(longtext.substring(0, i), shorttext.substring(0, j));
            if (((String)bestCommon).length() >= suffixLength + prefixLength) continue;
            bestCommon = shorttext.substring(j - suffixLength, j) + shorttext.substring(j, j + prefixLength);
            bestLongtextA = longtext.substring(0, i - suffixLength);
            bestLongtextB = longtext.substring(i + prefixLength);
            bestShorttextA = shorttext.substring(0, j - suffixLength);
            bestShorttextB = shorttext.substring(j + prefixLength);
        }
        if (((String)bestCommon).length() * 2 >= longtext.length()) {
            return new String[]{bestLongtextA, bestLongtextB, bestShorttextA, bestShorttextB, bestCommon};
        }
        return null;
    }

    public void diffCleanupSemantic(LinkedList<Diff> diffs) {
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        Stack<Diff> equalities = new Stack<Diff>();
        String lastequality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        int lengthInsertions1 = 0;
        int lengthDeletions1 = 0;
        int lengthInsertions2 = 0;
        int lengthDeletions2 = 0;
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.getOperation() == Operation.EQUAL) {
                equalities.push(thisDiff);
                lengthInsertions1 = lengthInsertions2;
                lengthDeletions1 = lengthDeletions2;
                lengthInsertions2 = 0;
                lengthDeletions2 = 0;
                lastequality = thisDiff.getText();
            } else {
                if (thisDiff.getOperation() == Operation.INSERT) {
                    lengthInsertions2 += thisDiff.getText().length();
                } else {
                    lengthDeletions2 += thisDiff.getText().length();
                }
                if (lastequality != null && lastequality.length() <= Math.max(lengthInsertions1, lengthDeletions1) && lastequality.length() <= Math.max(lengthInsertions2, lengthDeletions2)) {
                    while (thisDiff != equalities.lastElement()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, lastequality));
                    pointer.add(new Diff(Operation.INSERT, lastequality));
                    equalities.pop();
                    if (!equalities.empty()) {
                        equalities.pop();
                    }
                    if (equalities.empty()) {
                        while (pointer.hasPrevious()) {
                            pointer.previous();
                        }
                    } else {
                        thisDiff = (Diff)equalities.lastElement();
                        while (thisDiff != pointer.previous()) {
                        }
                    }
                    lengthInsertions1 = 0;
                    lengthInsertions2 = 0;
                    lengthDeletions1 = 0;
                    lengthDeletions2 = 0;
                    lastequality = null;
                    changes = true;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
        this.diffCleanupSemanticLossless(diffs);
        pointer = diffs.listIterator();
        Diff prevDiff = null;
        thisDiff = null;
        if (pointer.hasNext()) {
            prevDiff = (Diff)pointer.next();
            if (pointer.hasNext()) {
                thisDiff = (Diff)pointer.next();
            }
        }
        while (thisDiff != null) {
            if (prevDiff.getOperation() == Operation.DELETE && thisDiff.getOperation() == Operation.INSERT) {
                int overlapLength2;
                String insertion;
                String deletion = prevDiff.getText();
                int overlapLength1 = this.diffCommonOverlap(deletion, insertion = thisDiff.getText());
                if (overlapLength1 >= (overlapLength2 = this.diffCommonOverlap(insertion, deletion))) {
                    if ((double)overlapLength1 >= (double)deletion.length() / 2.0 || (double)overlapLength1 >= (double)insertion.length() / 2.0) {
                        pointer.previous();
                        pointer.add(new Diff(Operation.EQUAL, insertion.substring(0, overlapLength1)));
                        prevDiff.setText(deletion.substring(0, deletion.length() - overlapLength1));
                        thisDiff.setText(insertion.substring(overlapLength1));
                    }
                } else if ((double)overlapLength2 >= (double)deletion.length() / 2.0 || (double)overlapLength2 >= (double)insertion.length() / 2.0) {
                    pointer.previous();
                    pointer.add(new Diff(Operation.EQUAL, deletion.substring(0, overlapLength2)));
                    prevDiff.setOperation(Operation.INSERT);
                    prevDiff.setText(insertion.substring(0, insertion.length() - overlapLength2));
                    thisDiff.setOperation(Operation.DELETE);
                    thisDiff.setText(deletion.substring(overlapLength2));
                }
                thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
            }
            prevDiff = thisDiff;
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
    }

    public void diffCleanupSemanticLossless(List<Diff> diffs) {
        Diff nextDiff;
        StringBuilder equality1 = new StringBuilder();
        StringBuilder equality2 = new StringBuilder();
        ListIterator<Diff> pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? pointer.next() : null;
        Diff thisDiff = pointer.hasNext() ? pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.getOperation() == Operation.EQUAL && nextDiff.getOperation() == Operation.EQUAL) {
                String substring;
                equality1.setLength(0);
                equality1.append(prevDiff.getText());
                Object edit = thisDiff.getText();
                equality2.setLength(0);
                equality2.append(nextDiff.getText());
                int commonOffset = this.diffCommonSuffix(equality1.toString(), (String)edit);
                if (commonOffset != 0) {
                    String commonString = ((String)edit).substring(((String)edit).length() - commonOffset);
                    substring = equality1.substring(0, equality1.length() - commonOffset);
                    equality1.setLength(0);
                    equality1.append(substring);
                    edit = commonString + ((String)edit).substring(0, ((String)edit).length() - commonOffset);
                    equality2.insert(0, commonString);
                }
                String bestEquality1 = equality1.toString();
                Object bestEdit = edit;
                String bestEquality2 = equality2.toString();
                int bestScore = this.diffCleanupSemanticScore(equality1.toString(), (String)edit) + this.diffCleanupSemanticScore((String)edit, equality2.toString());
                while (((String)edit).length() != 0 && equality2.length() != 0 && ((String)edit).charAt(0) == equality2.charAt(0)) {
                    equality1.append(Character.toString(((String)edit).charAt(0)));
                    edit = ((String)edit).substring(1) + equality2.charAt(0);
                    substring = equality2.substring(1);
                    equality2.setLength(0);
                    equality2.append(substring);
                    int score = this.diffCleanupSemanticScore(equality1.toString(), (String)edit) + this.diffCleanupSemanticScore((String)edit, equality2.toString());
                    if (score < bestScore) continue;
                    bestScore = score;
                    bestEquality1 = equality1.toString();
                    bestEdit = edit;
                    bestEquality2 = equality2.toString();
                }
                if (!prevDiff.getText().equals(bestEquality1)) {
                    if (bestEquality1.length() != 0) {
                        prevDiff.setText(bestEquality1);
                    } else {
                        pointer.previous();
                        pointer.previous();
                        pointer.previous();
                        pointer.remove();
                        pointer.next();
                        pointer.next();
                    }
                    thisDiff.setText((String)bestEdit);
                    if (bestEquality2.length() != 0) {
                        nextDiff.setText(bestEquality2);
                    } else {
                        pointer.remove();
                        nextDiff = thisDiff;
                        thisDiff = prevDiff;
                    }
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? pointer.next() : null;
        }
    }

    private int diffCleanupSemanticScore(String one, String two) {
        boolean blankLine2;
        if (one.length() == 0 || two.length() == 0) {
            return 6;
        }
        char char1 = one.charAt(one.length() - 1);
        char char2 = two.charAt(0);
        boolean nonAlphaNumeric1 = !Character.isLetterOrDigit(char1);
        boolean nonAlphaNumeric2 = !Character.isLetterOrDigit(char2);
        boolean whitespace1 = nonAlphaNumeric1 && Character.isWhitespace(char1);
        boolean whitespace2 = nonAlphaNumeric2 && Character.isWhitespace(char2);
        boolean lineBreak1 = whitespace1 && Character.getType(char1) == 15;
        boolean lineBreak2 = whitespace2 && Character.getType(char2) == 15;
        boolean blankLine1 = lineBreak1 && BLANK_LINE_END.matcher(one).find();
        boolean bl = blankLine2 = lineBreak2 && BLANK_LINE_START.matcher(two).find();
        if (blankLine1 || blankLine2) {
            return 5;
        }
        if (lineBreak1 || lineBreak2) {
            return 4;
        }
        if (nonAlphaNumeric1 && !whitespace1 && whitespace2) {
            return 3;
        }
        if (whitespace1 || whitespace2) {
            return 2;
        }
        if (nonAlphaNumeric1 || nonAlphaNumeric2) {
            return 1;
        }
        return 0;
    }

    public void diffCleanupEfficiency(LinkedList<Diff> diffs) {
        Diff thisDiff;
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        Stack<Diff> equalities = new Stack<Diff>();
        String lastequality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        boolean preIns = false;
        boolean preDel = false;
        boolean postIns = false;
        boolean postDel = false;
        Diff safeDiff = thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.getOperation() == Operation.EQUAL) {
                if (thisDiff.getText().length() < 4 && (postIns || postDel)) {
                    equalities.push(thisDiff);
                    preIns = postIns;
                    preDel = postDel;
                    lastequality = thisDiff.getText();
                } else {
                    equalities.clear();
                    lastequality = null;
                    safeDiff = thisDiff;
                }
                postDel = false;
                postIns = false;
            } else {
                if (thisDiff.getOperation() == Operation.DELETE) {
                    postDel = true;
                } else {
                    postIns = true;
                }
                if (lastequality != null && (preIns && preDel && postIns && postDel || lastequality.length() < 2 && (preIns ? 1 : 0) + (preDel ? 1 : 0) + (postIns ? 1 : 0) + (postDel ? 1 : 0) == 3)) {
                    while (thisDiff != equalities.lastElement()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, lastequality));
                    thisDiff = new Diff(Operation.INSERT, lastequality);
                    pointer.add(thisDiff);
                    equalities.pop();
                    lastequality = null;
                    if (preIns && preDel) {
                        postDel = true;
                        postIns = true;
                        equalities.clear();
                        safeDiff = thisDiff;
                    } else {
                        if (!equalities.empty()) {
                            equalities.pop();
                        }
                        thisDiff = equalities.empty() ? safeDiff : (Diff)equalities.lastElement();
                        while (thisDiff != pointer.previous()) {
                        }
                        postDel = false;
                        postIns = false;
                    }
                    changes = true;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
    }

    public void diffCleanupMerge(LinkedList<Diff> diffs) {
        Diff nextDiff;
        diffs.add(new Diff(Operation.EQUAL, ""));
        ListIterator<Diff> pointer = diffs.listIterator();
        int countDelete = 0;
        int countInsert = 0;
        StringBuilder textDelete = new StringBuilder();
        StringBuilder textInsert = new StringBuilder();
        Diff thisDiff = (Diff)pointer.next();
        Diff prevEqual = null;
        while (thisDiff != null) {
            switch (thisDiff.getOperation()) {
                case INSERT: {
                    ++countInsert;
                    textInsert.append(thisDiff.getText());
                    prevEqual = null;
                    break;
                }
                case DELETE: {
                    ++countDelete;
                    textDelete.append(thisDiff.getText());
                    prevEqual = null;
                    break;
                }
                case EQUAL: {
                    if (countDelete + countInsert > 1) {
                        boolean bothTypes = countDelete != 0 && countInsert != 0;
                        pointer.previous();
                        while (countDelete-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        while (countInsert-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        if (bothTypes) {
                            String substringDel;
                            String substringIns;
                            int commonlength = this.diffCommonPrefix(textInsert.toString(), textDelete.toString());
                            if (commonlength != 0) {
                                if (pointer.hasPrevious()) {
                                    thisDiff = (Diff)pointer.previous();
                                    thisDiff.setText(thisDiff.getText() + textInsert.substring(0, commonlength));
                                    pointer.next();
                                } else {
                                    pointer.add(new Diff(Operation.EQUAL, textInsert.substring(0, commonlength)));
                                }
                                substringIns = textInsert.substring(commonlength);
                                textInsert.setLength(0);
                                textInsert.append(substringIns);
                                substringDel = textDelete.substring(commonlength);
                                textDelete.setLength(0);
                                textDelete.append(substringDel);
                            }
                            if ((commonlength = this.diffCommonSuffix(textInsert.toString(), textDelete.toString())) != 0) {
                                thisDiff = (Diff)pointer.next();
                                thisDiff.setText(textInsert.substring(textInsert.length() - commonlength) + thisDiff.getText());
                                substringIns = textInsert.substring(0, textInsert.length() - commonlength);
                                textInsert.setLength(0);
                                textInsert.append(substringIns);
                                substringDel = textDelete.substring(0, textDelete.length() - commonlength);
                                textDelete.setLength(0);
                                textDelete.append(substringDel);
                                pointer.previous();
                            }
                        }
                        if (textDelete.length() != 0) {
                            pointer.add(new Diff(Operation.DELETE, textDelete.toString()));
                        }
                        if (textInsert.length() != 0) {
                            pointer.add(new Diff(Operation.INSERT, textInsert.toString()));
                        }
                        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    } else if (prevEqual != null) {
                        prevEqual.setText(prevEqual.getText() + thisDiff.getText());
                        pointer.remove();
                        thisDiff = (Diff)pointer.previous();
                        pointer.next();
                    }
                    countInsert = 0;
                    countDelete = 0;
                    textDelete.setLength(0);
                    textInsert.setLength(0);
                    prevEqual = thisDiff;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (diffs.getLast().getText().length() == 0) {
            diffs.removeLast();
        }
        boolean changes = false;
        pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.getOperation() == Operation.EQUAL && nextDiff.getOperation() == Operation.EQUAL) {
                if (thisDiff.getText().endsWith(prevDiff.getText())) {
                    thisDiff.setText(prevDiff.getText() + thisDiff.getText().substring(0, thisDiff.getText().length() - prevDiff.getText().length()));
                    nextDiff.setText(prevDiff.getText() + nextDiff.getText());
                    pointer.previous();
                    pointer.previous();
                    pointer.previous();
                    pointer.remove();
                    pointer.next();
                    thisDiff = (Diff)pointer.next();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                } else if (thisDiff.getText().startsWith(nextDiff.getText())) {
                    prevDiff.setText(prevDiff.getText() + nextDiff.getText());
                    thisDiff.setText(thisDiff.getText().substring(nextDiff.getText().length()) + nextDiff.getText());
                    pointer.remove();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
    }

    public int diffXIndex(List<Diff> diffs, int loc) {
        int chars1 = 0;
        int chars2 = 0;
        int lastChars1 = 0;
        int lastChars2 = 0;
        Diff lastDiff = null;
        for (Diff aDiff : diffs) {
            if (aDiff.getOperation() != Operation.INSERT) {
                chars1 += aDiff.getText().length();
            }
            if (aDiff.getOperation() != Operation.DELETE) {
                chars2 += aDiff.getText().length();
            }
            if (chars1 > loc) {
                lastDiff = aDiff;
                break;
            }
            lastChars1 = chars1;
            lastChars2 = chars2;
        }
        if (lastDiff != null && lastDiff.getOperation() == Operation.DELETE) {
            return lastChars2;
        }
        return lastChars2 + (loc - lastChars1);
    }

    public String diffPrettyHtml(List<Diff> diffs) {
        StringBuilder html = new StringBuilder();
        for (Diff aDiff : diffs) {
            String text = aDiff.getText().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "&para;<br>");
            switch (aDiff.getOperation()) {
                case INSERT: {
                    html.append("<ins style=\"background:#e6ffe6;\">").append(text).append("</ins>");
                    break;
                }
                case DELETE: {
                    html.append("<del style=\"background:#ffe6e6;\">").append(text).append("</del>");
                    break;
                }
                case EQUAL: {
                    html.append("<span>").append(text).append("</span>");
                }
            }
        }
        return html.toString();
    }

    public String diffText1(List<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            if (aDiff.getOperation() == Operation.INSERT) continue;
            text.append(aDiff.getText());
        }
        return text.toString();
    }

    public String diffText2(List<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            if (aDiff.getOperation() == Operation.DELETE) continue;
            text.append(aDiff.getText());
        }
        return text.toString();
    }

    public int diffLevenshtein(List<Diff> diffs) {
        int levenshtein = 0;
        int insertions = 0;
        int deletions = 0;
        for (Diff aDiff : diffs) {
            switch (aDiff.getOperation()) {
                case INSERT: {
                    insertions += aDiff.getText().length();
                    break;
                }
                case DELETE: {
                    deletions += aDiff.getText().length();
                    break;
                }
                case EQUAL: {
                    levenshtein += Math.max(insertions, deletions);
                    insertions = 0;
                    deletions = 0;
                }
            }
        }
        return levenshtein += Math.max(insertions, deletions);
    }

    public String diffToDelta(List<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            switch (aDiff.getOperation()) {
                case INSERT: {
                    text.append("+").append(URLEncoder.encode(aDiff.getText(), StandardCharsets.UTF_8).replace('+', ' ')).append("\t");
                    break;
                }
                case DELETE: {
                    text.append("-").append(aDiff.getText().length()).append("\t");
                    break;
                }
                case EQUAL: {
                    text.append("=").append(aDiff.getText().length()).append("\t");
                }
            }
        }
        String delta = text.toString();
        if (delta.length() != 0) {
            delta = delta.substring(0, delta.length() - 1);
            delta = Patch.unescapeForEncodeUriCompatability(delta);
        }
        return delta;
    }

    public List<Diff> diffFromDelta(String text1, String delta) {
        String[] tokens;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        int pointer = 0;
        block10: for (String token : tokens = delta.split("\t")) {
            if (token.length() == 0) continue;
            String param = token.substring(1);
            switch (token.charAt(0)) {
                case '+': {
                    param = param.replace("+", "%2B");
                    try {
                        param = URLDecoder.decode(param, StandardCharsets.UTF_8);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Illegal escape in diff_fromDelta: " + param, e);
                    }
                    diffs.add(new Diff(Operation.INSERT, param));
                    continue block10;
                }
                case '-': 
                case '=': {
                    String text;
                    int n;
                    try {
                        n = Integer.parseInt(param);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid number in diff_fromDelta: " + param, e);
                    }
                    if (n < 0) {
                        throw new IllegalArgumentException("Negative number in diff_fromDelta: " + param);
                    }
                    try {
                        int p1 = pointer;
                        int p2 = pointer += n;
                        text = text1.substring(p1, p2);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("Delta length (" + pointer + ") larger than source text length (" + text1.length() + ").", e);
                    }
                    if (token.charAt(0) == '=') {
                        diffs.add(new Diff(Operation.EQUAL, text));
                        continue block10;
                    }
                    diffs.add(new Diff(Operation.DELETE, text));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Invalid diff operation in diff_fromDelta: " + token.charAt(0));
                }
            }
        }
        if (pointer != text1.length()) {
            throw new IllegalArgumentException("Delta length (" + pointer + ") smaller than source text length (" + text1.length() + ").");
        }
        return diffs;
    }

    public int matchMain(String text, String pattern, int valueLoc) {
        if (text == null || pattern == null) {
            throw new IllegalArgumentException("Null inputs. (match_main)");
        }
        int loc = Math.max(0, Math.min(valueLoc, text.length()));
        if (text.equals(pattern)) {
            return 0;
        }
        if (text.length() == 0) {
            return -1;
        }
        if (loc + pattern.length() <= text.length() && text.substring(loc, loc + pattern.length()).equals(pattern)) {
            return loc;
        }
        return this.matchBitap(text, pattern, loc);
    }

    protected int matchBitap(String text, String pattern, int loc) {
        Map<Character, Integer> s = this.matchAlphabet(pattern);
        double scoreThreshold = 0.5;
        int bestLoc = text.indexOf(pattern, loc);
        if (bestLoc != -1) {
            scoreThreshold = Math.min(this.matchBitapScore(0, bestLoc, loc, pattern), scoreThreshold);
            bestLoc = text.lastIndexOf(pattern, loc + pattern.length());
            if (bestLoc != -1) {
                scoreThreshold = Math.min(this.matchBitapScore(0, bestLoc, loc, pattern), scoreThreshold);
            }
        }
        int matchmask = 1 << pattern.length() - 1;
        bestLoc = -1;
        int binMax = pattern.length() + text.length();
        int[] lastRd = new int[]{};
        for (int d = 0; d < pattern.length(); ++d) {
            int binMin = 0;
            int binMid = binMax;
            while (binMin < binMid) {
                if (this.matchBitapScore(d, loc + binMid, loc, pattern) <= scoreThreshold) {
                    binMin = binMid;
                } else {
                    binMax = binMid;
                }
                binMid = (binMax - binMin) / 2 + binMin;
            }
            binMax = binMid;
            int start = Math.max(1, loc - binMid + 1);
            int finish = Math.min(loc + binMid, text.length()) + pattern.length();
            int[] rd = new int[finish + 2];
            rd[finish + 1] = (1 << d) - 1;
            for (int j = finish; j >= start; --j) {
                double score;
                int charMatch = text.length() <= j - 1 || !s.containsKey(Character.valueOf(text.charAt(j - 1))) ? 0 : s.get(Character.valueOf(text.charAt(j - 1)));
                rd[j] = d == 0 ? (rd[j + 1] << 1 | 1) & charMatch : (rd[j + 1] << 1 | 1) & charMatch | ((lastRd[j + 1] | lastRd[j]) << 1 | 1) | lastRd[j + 1];
                if ((rd[j] & matchmask) == 0 || !((score = this.matchBitapScore(d, j - 1, loc, pattern)) <= scoreThreshold)) continue;
                scoreThreshold = score;
                bestLoc = j - 1;
                if (bestLoc <= loc) break;
                start = Math.max(1, 2 * loc - bestLoc);
            }
            if (this.matchBitapScore(d + 1, loc, loc, pattern) > scoreThreshold) break;
            lastRd = rd;
        }
        return bestLoc;
    }

    private double matchBitapScore(int e, int x, int loc, String pattern) {
        float accuracy = (float)e / (float)pattern.length();
        int proximity = Math.abs(loc - x);
        return accuracy + (float)proximity / 1000.0f;
    }

    protected Map<Character, Integer> matchAlphabet(String pattern) {
        char[] charPattern;
        HashMap<Character, Integer> s = new HashMap<Character, Integer>();
        for (char c : charPattern = pattern.toCharArray()) {
            s.put(Character.valueOf(c), 0);
        }
        int i = 0;
        for (char c : charPattern) {
            s.put(Character.valueOf(c), (Integer)s.get(Character.valueOf(c)) | 1 << pattern.length() - i - 1);
            ++i;
        }
        return s;
    }

    protected void patchAddContext(Patch patch, String text) {
        String suffix;
        if (text.length() == 0) {
            return;
        }
        String pattern = text.substring(patch.getStart2(), patch.getStart2() + patch.getLength1());
        int padding = 0;
        while (text.indexOf(pattern) != text.lastIndexOf(pattern) && pattern.length() < 24) {
            pattern = text.substring(Math.max(0, patch.getStart2() - (padding += 4)), Math.min(text.length(), patch.getStart2() + patch.getLength1() + padding));
        }
        String prefix = text.substring(Math.max(0, patch.getStart2() - (padding += 4)), patch.getStart2());
        if (prefix.length() != 0) {
            patch.getDiffs().addFirst(new Diff(Operation.EQUAL, prefix));
        }
        if ((suffix = text.substring(patch.getStart2() + patch.getLength1(), Math.min(text.length(), patch.getStart2() + patch.getLength1() + padding))).length() != 0) {
            patch.getDiffs().addLast(new Diff(Operation.EQUAL, suffix));
        }
        patch.setStart1(patch.getStart1() - prefix.length());
        patch.setStart2(patch.getStart2() - prefix.length());
        patch.setLength1(patch.getLength1() + prefix.length() + suffix.length());
        patch.setLength2(patch.getLength2() + prefix.length() + suffix.length());
    }

    public List<Patch> patchMake(String text1, String text2) {
        if (text1 == null || text2 == null) {
            throw new IllegalArgumentException("Null inputs. (patch_make)");
        }
        LinkedList<Diff> diffs = this.diffMain(text1, text2, true);
        if (diffs.size() > 2) {
            this.diffCleanupSemantic(diffs);
            this.diffCleanupEfficiency(diffs);
        }
        return this.patchMake(text1, diffs);
    }

    public List<Patch> patchMake(LinkedList<Diff> diffs) {
        if (diffs == null) {
            throw new IllegalArgumentException("Null inputs. (patch_make)");
        }
        String text1 = this.diffText1(diffs);
        return this.patchMake(text1, diffs);
    }

    public List<Patch> patchMake(String text1, Deque<Diff> diffs) {
        if (text1 == null || diffs == null) {
            throw new IllegalArgumentException("Null inputs. (patch_make)");
        }
        LinkedList<Patch> patches = new LinkedList<Patch>();
        if (diffs.isEmpty()) {
            return patches;
        }
        Patch patch = new Patch();
        int charCount1 = 0;
        int charCount2 = 0;
        Object prepatchText = text1;
        Object postpatchText = text1;
        for (Diff aDiff : diffs) {
            if (patch.getDiffs().isEmpty() && aDiff.getOperation() != Operation.EQUAL) {
                patch.setStart1(charCount1);
                patch.setStart2(charCount2);
            }
            switch (aDiff.getOperation()) {
                case INSERT: {
                    patch.getDiffs().add(aDiff);
                    patch.setLength2(patch.getLength2() + aDiff.getText().length());
                    postpatchText = ((String)postpatchText).substring(0, charCount2) + aDiff.getText() + ((String)postpatchText).substring(charCount2);
                    break;
                }
                case DELETE: {
                    patch.setLength1(patch.getLength1() + aDiff.getText().length());
                    patch.getDiffs().add(aDiff);
                    postpatchText = ((String)postpatchText).substring(0, charCount2) + ((String)postpatchText).substring(charCount2 + aDiff.getText().length());
                    break;
                }
                case EQUAL: {
                    if (aDiff.getText().length() <= 8 && !patch.getDiffs().isEmpty() && aDiff != diffs.getLast()) {
                        patch.getDiffs().add(aDiff);
                        patch.setLength1(patch.getLength1() + aDiff.getText().length());
                        patch.setLength2(patch.getLength2() + aDiff.getText().length());
                    }
                    if (aDiff.getText().length() < 8 || patch.getDiffs().isEmpty()) break;
                    this.patchAddContext(patch, (String)prepatchText);
                    patches.add(patch);
                    patch = new Patch();
                    prepatchText = postpatchText;
                    charCount1 = charCount2;
                }
            }
            if (aDiff.getOperation() != Operation.INSERT) {
                charCount1 += aDiff.getText().length();
            }
            if (aDiff.getOperation() == Operation.DELETE) continue;
            charCount2 += aDiff.getText().length();
        }
        if (!patch.getDiffs().isEmpty()) {
            this.patchAddContext(patch, (String)prepatchText);
            patches.add(patch);
        }
        return patches;
    }

    public LinkedList<Patch> patchDeepCopy(List<Patch> patches) {
        LinkedList<Patch> patchesCopy = new LinkedList<Patch>();
        for (Patch aPatch : patches) {
            Patch patchCopy = new Patch();
            for (Diff aDiff : aPatch.getDiffs()) {
                Diff diffCopy = new Diff(aDiff.getOperation(), aDiff.getText());
                patchCopy.getDiffs().add(diffCopy);
            }
            patchCopy.setStart1(aPatch.getStart1());
            patchCopy.setStart2(aPatch.getStart2());
            patchCopy.setLength1(aPatch.getLength1());
            patchCopy.setLength2(aPatch.getLength2());
            patchesCopy.add(patchCopy);
        }
        return patchesCopy;
    }

    public Object[] patchApply(LinkedList<Patch> valuePatches, String valueText) {
        if (valuePatches.isEmpty()) {
            return new Object[]{valueText, new boolean[0]};
        }
        LinkedList<Patch> patches = this.patchDeepCopy(valuePatches);
        String nullPadding = this.patchAddPadding(patches);
        Object text = nullPadding + valueText + nullPadding;
        this.patchSplitMax(patches);
        int x = 0;
        int delta = 0;
        boolean[] results = new boolean[patches.size()];
        for (Patch aPatch : patches) {
            int startLoc;
            int expectedLoc = aPatch.getStart2() + delta;
            String text1 = this.diffText1(aPatch.getDiffs());
            int endLoc = -1;
            if (text1.length() > 32) {
                startLoc = this.matchMain((String)text, text1.substring(0, 32), expectedLoc);
                if (startLoc != -1 && ((endLoc = this.matchMain((String)text, text1.substring(text1.length() - 32), expectedLoc + text1.length() - 32)) == -1 || startLoc >= endLoc)) {
                    startLoc = -1;
                }
            } else {
                startLoc = this.matchMain((String)text, text1, expectedLoc);
            }
            if (startLoc == -1) {
                results[x] = false;
                delta -= aPatch.getLength2() - aPatch.getLength1();
            } else {
                results[x] = true;
                delta = startLoc - expectedLoc;
                String text2 = endLoc == -1 ? ((String)text).substring(startLoc, Math.min(startLoc + text1.length(), ((String)text).length())) : ((String)text).substring(startLoc, Math.min(endLoc + 32, ((String)text).length()));
                if (text1.equals(text2)) {
                    text = ((String)text).substring(0, startLoc) + this.diffText2(aPatch.getDiffs()) + ((String)text).substring(startLoc + text1.length());
                } else {
                    LinkedList<Diff> diffs = this.diffMain(text1, text2, false);
                    if (text1.length() > 32 && (float)this.diffLevenshtein(diffs) / (float)text1.length() > 0.5f) {
                        results[x] = false;
                    } else {
                        this.diffCleanupSemanticLossless(diffs);
                        int index1 = 0;
                        for (Diff aDiff : aPatch.getDiffs()) {
                            if (aDiff.getOperation() != Operation.EQUAL) {
                                int index2 = this.diffXIndex(diffs, index1);
                                if (aDiff.getOperation() == Operation.INSERT) {
                                    text = ((String)text).substring(0, startLoc + index2) + aDiff.getText() + ((String)text).substring(startLoc + index2);
                                } else if (aDiff.getOperation() == Operation.DELETE) {
                                    text = ((String)text).substring(0, startLoc + index2) + ((String)text).substring(startLoc + this.diffXIndex(diffs, index1 + aDiff.getText().length()));
                                }
                            }
                            if (aDiff.getOperation() == Operation.DELETE) continue;
                            index1 += aDiff.getText().length();
                        }
                    }
                }
            }
            ++x;
        }
        text = ((String)text).substring(nullPadding.length(), ((String)text).length() - nullPadding.length());
        return new Object[]{text, results};
    }

    public String patchAddPadding(Deque<Patch> patches) {
        int extraLength;
        int paddingLength = 4;
        StringBuilder nullPadding = new StringBuilder();
        for (int x = 1; x <= paddingLength; x = (int)((short)(x + 1))) {
            nullPadding.append(String.valueOf((char)x));
        }
        for (Patch aPatch : patches) {
            aPatch.setStart1(aPatch.getStart1() + paddingLength);
            aPatch.setStart2(aPatch.getStart2() + paddingLength);
        }
        Patch patch = patches.getFirst();
        LinkedList<Diff> diffs = patch.getDiffs();
        if (diffs.isEmpty() || ((Diff)diffs.getFirst()).getOperation() != Operation.EQUAL) {
            diffs.addFirst(new Diff(Operation.EQUAL, nullPadding.toString()));
            patch.setStart1(patch.getStart1() - paddingLength);
            patch.setStart2(patch.getStart2() - paddingLength);
            patch.setLength1(patch.getLength1() + paddingLength);
            patch.setLength2(patch.getLength2() + paddingLength);
        } else if (paddingLength > ((Diff)diffs.getFirst()).getText().length()) {
            Diff firstDiff = (Diff)diffs.getFirst();
            extraLength = paddingLength - firstDiff.getText().length();
            firstDiff.setText(nullPadding.substring(firstDiff.getText().length()) + firstDiff.getText());
            patch.setStart1(patch.getStart1() - extraLength);
            patch.setStart2(patch.getStart2() - extraLength);
            patch.setLength1(patch.getLength1() + extraLength);
            patch.setLength2(patch.getLength2() + extraLength);
        }
        patch = patches.getLast();
        diffs = patch.getDiffs();
        if (diffs.isEmpty() || ((Diff)diffs.getLast()).getOperation() != Operation.EQUAL) {
            diffs.addLast(new Diff(Operation.EQUAL, nullPadding.toString()));
            patch.setLength1(patch.getLength1() + paddingLength);
            patch.setLength2(patch.getLength2() + paddingLength);
        } else if (paddingLength > ((Diff)diffs.getLast()).getText().length()) {
            Diff lastDiff = (Diff)diffs.getLast();
            extraLength = paddingLength - lastDiff.getText().length();
            lastDiff.setText(lastDiff.getText() + nullPadding.substring(0, extraLength));
            patch.setLength1(patch.getLength1() + extraLength);
            patch.setLength2(patch.getLength2() + extraLength);
        }
        return nullPadding.toString();
    }

    public void patchSplitMax(List<Patch> patches) {
        Patch bigpatch;
        int patchSize = 32;
        ListIterator<Patch> pointer = patches.listIterator();
        Patch patch = bigpatch = pointer.hasNext() ? pointer.next() : null;
        while (bigpatch != null) {
            if (bigpatch.getLength1() <= 32) {
                bigpatch = pointer.hasNext() ? pointer.next() : null;
                continue;
            }
            pointer.remove();
            int start1 = bigpatch.getStart1();
            int start2 = bigpatch.getStart2();
            String precontext = "";
            while (!bigpatch.getDiffs().isEmpty()) {
                Patch patch2 = new Patch();
                boolean empty = true;
                patch2.setStart1(start1 - precontext.length());
                patch2.setStart2(start2 - precontext.length());
                if (precontext.length() != 0) {
                    patch2.setLength1(patch2.setLength2(precontext.length()));
                    patch2.getDiffs().add(new Diff(Operation.EQUAL, precontext));
                }
                while (!bigpatch.getDiffs().isEmpty() && patch2.getLength1() < patchSize - 4) {
                    Operation diffType = bigpatch.getDiffs().getFirst().getOperation();
                    String diffText = bigpatch.getDiffs().getFirst().getText();
                    if (diffType == Operation.INSERT) {
                        patch2.setLength2(patch2.getLength2() + diffText.length());
                        start2 += diffText.length();
                        patch2.getDiffs().addLast(bigpatch.getDiffs().removeFirst());
                        empty = false;
                        continue;
                    }
                    if (diffType == Operation.DELETE && patch2.getDiffs().size() == 1 && patch2.getDiffs().getFirst().getOperation() == Operation.EQUAL && diffText.length() > 2 * patchSize) {
                        patch2.setLength1(patch2.getLength1() + diffText.length());
                        start1 += diffText.length();
                        empty = false;
                        patch2.getDiffs().add(new Diff(diffType, diffText));
                        bigpatch.getDiffs().removeFirst();
                        continue;
                    }
                    diffText = diffText.substring(0, Math.min(diffText.length(), patchSize - patch2.getLength1() - 4));
                    patch2.setLength1(patch2.getLength1() + diffText.length());
                    start1 += diffText.length();
                    if (diffType == Operation.EQUAL) {
                        patch2.setLength2(patch2.getLength2() + diffText.length());
                        start2 += diffText.length();
                    } else {
                        empty = false;
                    }
                    patch2.getDiffs().add(new Diff(diffType, diffText));
                    if (diffText.equals(bigpatch.getDiffs().getFirst().getText())) {
                        bigpatch.getDiffs().removeFirst();
                        continue;
                    }
                    bigpatch.getDiffs().getFirst().setText(bigpatch.getDiffs().getFirst().getText().substring(diffText.length()));
                }
                precontext = this.diffText2(patch2.getDiffs());
                precontext = precontext.substring(Math.max(0, precontext.length() - 4));
                String postcontext = this.diffText1(bigpatch.getDiffs()).length() > 4 ? this.diffText1(bigpatch.getDiffs()).substring(0, 4) : this.diffText1(bigpatch.getDiffs());
                if (postcontext.length() != 0) {
                    patch2.setLength1(patch2.getLength1() + postcontext.length());
                    patch2.setLength2(patch2.getLength2() + postcontext.length());
                    if (!patch2.getDiffs().isEmpty() && patch2.getDiffs().getLast().getOperation() == Operation.EQUAL) {
                        patch2.getDiffs().getLast().setText(patch2.getDiffs().getLast().getText() + postcontext);
                    } else {
                        patch2.getDiffs().add(new Diff(Operation.EQUAL, postcontext));
                    }
                }
                if (empty) continue;
                pointer.add(patch2);
            }
            bigpatch = pointer.hasNext() ? pointer.next() : null;
        }
    }

    public String patchToText(List<Patch> patches) {
        StringBuilder text = new StringBuilder();
        for (Patch aPatch : patches) {
            text.append(aPatch);
        }
        return text.toString();
    }

    public List<Patch> patchFromText(String textline) {
        LinkedList<Patch> patches = new LinkedList<Patch>();
        if (textline.length() == 0) {
            return patches;
        }
        List<String> textList = Arrays.asList(textline.split("\n"));
        LinkedList<String> text = new LinkedList<String>(textList);
        Pattern patchHeader = Pattern.compile("^@@ -(\\d+),?(\\d*) \\+(\\d+),?(\\d*) @@$");
        block4: while (!text.isEmpty()) {
            Matcher m = patchHeader.matcher((CharSequence)text.getFirst());
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid patch string: " + (String)text.getFirst());
            }
            Patch patch = new Patch();
            patches.add(patch);
            patch.setStart1(Integer.parseInt(m.group(1)));
            if (m.group(2).length() == 0) {
                patch.setStart1(patch.getStart1() - 1);
                patch.setLength1(1);
            } else if ("0".equals(m.group(2))) {
                patch.setLength1(0);
            } else {
                patch.setStart1(patch.getStart1() - 1);
                patch.setLength1(Integer.parseInt(m.group(2)));
            }
            patch.setStart2(Integer.parseInt(m.group(3)));
            if (m.group(4).length() == 0) {
                patch.setStart2(patch.getStart2() - 1);
                patch.setLength2(1);
            } else if ("0".equals(m.group(4))) {
                patch.setLength2(0);
            } else {
                patch.setStart2(patch.getStart2() - 1);
                patch.setLength2(Integer.parseInt(m.group(4)));
            }
            text.removeFirst();
            while (!text.isEmpty()) {
                char sign;
                try {
                    sign = ((String)text.getFirst()).charAt(0);
                }
                catch (IndexOutOfBoundsException e) {
                    LOGGER.log(LogLevelUtil.IGNORE, e);
                    text.removeFirst();
                    continue;
                }
                String line = ((String)text.getFirst()).substring(1);
                line = line.replace("+", "%2B");
                try {
                    line = URLDecoder.decode(line, StandardCharsets.UTF_8);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Illegal escape in patch_fromText: " + line, e);
                }
                if (sign == '-') {
                    patch.getDiffs().add(new Diff(Operation.DELETE, line));
                } else if (sign == '+') {
                    patch.getDiffs().add(new Diff(Operation.INSERT, line));
                } else if (sign == ' ') {
                    patch.getDiffs().add(new Diff(Operation.EQUAL, line));
                } else {
                    if (sign == '@') continue block4;
                    throw new IllegalArgumentException("Invalid patch mode '" + sign + "' in: " + line);
                }
                text.removeFirst();
            }
        }
        return patches;
    }

    public static enum Operation {
        DELETE,
        INSERT,
        EQUAL;

    }

    protected static class LinesToCharsResult {
        protected final String chars1;
        protected final String chars2;
        protected final List<String> lineArray;

        protected LinesToCharsResult(String chars1, String chars2, List<String> lineArray) {
            this.chars1 = chars1;
            this.chars2 = chars2;
            this.lineArray = lineArray;
        }
    }
}

