/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util.bruter;

import com.jsql.util.StringUtil;
import com.jsql.util.bruter.Crc16Helper;
import com.jsql.util.bruter.Crc64Helper;
import com.jsql.util.bruter.DigestMD4;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;

public class HashUtil {
    private HashUtil() {
    }

    public static String toAdler32(String text) {
        byte[] bytes = text.getBytes();
        Adler32 checksum = new Adler32();
        checksum.update(bytes, 0, bytes.length);
        return String.valueOf(checksum.getValue());
    }

    public static String toCrc16(String text) {
        return Crc16Helper.generateCRC16(text);
    }

    public static String toCrc64(String text) {
        return Crc64Helper.generateCRC64(text.getBytes());
    }

    public static String toMySql(String textInput) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("sha-1");
        String password = String.valueOf(textInput.toCharArray());
        byte[] passwordBytes = password.getBytes();
        md.update(passwordBytes, 0, passwordBytes.length);
        byte[] hashSHA1 = md.digest();
        String stringSHA1 = HashUtil.digestToHexString(hashSHA1);
        String passwordSHA1 = String.valueOf(StringUtil.hexstr(stringSHA1).toCharArray());
        byte[] passwordSHA1Bytes = passwordSHA1.getBytes();
        md.update(passwordSHA1Bytes, 0, passwordSHA1Bytes.length);
        byte[] hashSHA1SH1 = md.digest();
        return HashUtil.digestToHexString(hashSHA1SH1);
    }

    public static String toCrc32(String textInput) {
        byte[] bytes = textInput.getBytes();
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        long lngChecksum = checksum.getValue();
        return Long.toString(lngChecksum);
    }

    public static String toMd4(String textInput) {
        DigestMD4 md = new DigestMD4();
        String passwordString = String.valueOf(textInput.toCharArray());
        byte[] passwordByte = passwordString.getBytes();
        md.update(passwordByte, 0, passwordByte.length);
        byte[] encodedPassword = md.digest();
        return HashUtil.digestToHexString(encodedPassword);
    }

    public static String toHash(String nameMethod, String textInput) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(nameMethod);
        String passwordString = String.valueOf(textInput.toCharArray());
        byte[] passwordByte = passwordString.getBytes();
        md.update(passwordByte, 0, passwordByte.length);
        byte[] encodedPassword = md.digest();
        return HashUtil.digestToHexString(encodedPassword);
    }

    public static String digestToHexString(byte[] block) {
        StringBuilder buf = new StringBuilder();
        for (byte b : block) {
            HashUtil.byte2hex(b, buf);
        }
        return buf.toString();
    }

    private static void byte2hex(byte b, StringBuilder buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }
}

