/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.action;

import com.jsql.MainApplication;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionNewWindow
extends AbstractAction {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final String PATH = SystemUtils.JAVA_HOME + File.separator + "bin" + File.separator + "java";
    private static final List<String> COMMANDS_DEFAULT = Arrays.asList("-cp", SystemUtils.JAVA_CLASS_PATH, MainApplication.class.getName());
    private final List<String> commands = new ArrayList<String>(List.of(PATH));

    public ActionNewWindow() {
        this(I18nUtil.valueByKey("NEW_WINDOW_MENU"), new String[0]);
        this.putValue("MnemonicKey", 78);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 128));
    }

    public ActionNewWindow(String name, String ... commands) {
        this.commands.addAll(Arrays.asList(commands));
        this.commands.addAll(COMMANDS_DEFAULT);
        this.putValue("Name", name);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        LOGGER.log(LogLevelUtil.CONSOLE_INFORM, () -> I18nUtil.valueByKey("NEW_WINDOW_START"));
        ProcessBuilder processBuilder = new ProcessBuilder(this.commands.toArray(new String[0]));
        try {
            processBuilder.start();
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

