/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.action;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.dialog.ReplaceFileChooser;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.table.PanelTable;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionSaveTab
extends AbstractAction {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final ReplaceFileChooser filechooser = new ReplaceFileChooser(MediatorHelper.model().getMediatorUtils().getPreferencesUtil().getPathFile());

    public ActionSaveTab() {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 128));
        this.putValue("MnemonicKey", 83);
        this.putValue("Name", "Save Tab As...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.filechooser.setDialogTitle("Save Tab As");
        Component componentResult = MediatorHelper.tabResults().getSelectedComponent();
        if (componentResult instanceof PanelTable) {
            JTable table = ((PanelTable)componentResult).getTableValues();
            this.saveToFile(table);
        } else if (componentResult instanceof LightScrollPane && ((LightScrollPane)componentResult).scrollPane.getViewport().getView() instanceof JTextComponent) {
            JTextComponent textarea = (JTextComponent)((LightScrollPane)componentResult).scrollPane.getViewport().getView();
            this.saveToFile(textarea);
        }
    }

    private void saveToFile(JComponent textarea) {
        if (textarea == null) {
            return;
        }
        int stateSave = this.filechooser.showSaveDialog(MediatorHelper.frame());
        if (stateSave == 0) {
            String folderSelectedFile = this.filechooser.getCurrentDirectory().toString();
            MediatorHelper.model().getMediatorUtils().getPreferencesUtil().set(folderSelectedFile);
            if (textarea instanceof JTextComponent) {
                this.saveTextToFile((JTextComponent)textarea);
            } else if (textarea instanceof JTable) {
                this.saveTableToFile((JTable)textarea);
            }
        }
    }

    private void saveTableToFile(JTable tableResults) {
        File fileSelected = this.filechooser.getSelectedFile();
        try (FileWriter fileWriterExcel = new FileWriter(fileSelected);){
            int i;
            TableModel tableModel = tableResults.getModel();
            for (i = 2; i < tableModel.getColumnCount(); ++i) {
                fileWriterExcel.write(tableModel.getColumnName(i) + "\t");
            }
            fileWriterExcel.write("\n");
            for (i = 0; i < tableModel.getRowCount(); ++i) {
                for (int j = 2; j < tableModel.getColumnCount(); ++j) {
                    if (tableModel.getValueAt(i, j) == null) {
                        fileWriterExcel.write("\t");
                        continue;
                    }
                    Object line = tableModel.getValueAt(i, j).toString();
                    line = ((String)line).replace("\n", "\\n").replace("\t", "\\t");
                    line = (String)line + "\t";
                    fileWriterExcel.write((String)line);
                }
                fileWriterExcel.write("\n");
            }
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("Error writing to %s", fileSelected.getName()), (Throwable)e);
        }
    }

    private void saveTextToFile(JTextComponent textarea) {
        File fileSelected = this.filechooser.getSelectedFile();
        try (FileWriter fileWriter = new FileWriter(fileSelected);
             BufferedWriter fileOut = new BufferedWriter(fileWriter);){
            textarea.write(fileOut);
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("Error writing to %s", fileSelected.getName()), (Throwable)e);
        }
    }
}

