/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.dialog;

import com.jsql.util.GitUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.dialog.translate.Language;
import com.jsql.view.swing.dialog.translate.SwingWorkerGithubLocale;
import com.jsql.view.swing.popupmenu.JPopupMenuText;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.text.JPopupTextArea;
import com.jsql.view.swing.text.JTextAreaPlaceholder;
import com.jsql.view.swing.ui.FlatButtonMouseAdapter;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicProgressBarUI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogTranslate
extends JDialog {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final JButton buttonSend = new JButton("Send");
    private Language language;
    private final JLabel labelTranslation = new JLabel();
    private final JTextArea textToTranslate = (JTextArea)new JPopupTextArea(new JTextAreaPlaceholder("Text to translate")).getProxy();
    private final JProgressBar progressBarTranslation = new JProgressBar();
    private String textBeforeChange = "";

    public DialogTranslate() {
        super((Window)MediatorHelper.frame(), Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(2);
        this.setIconImages(UiUtil.getIcons());
        ActionListener escapeListener = actionEvent -> this.dispose();
        this.getRootPane().registerKeyboardAction(escapeListener, KeyStroke.getKeyStroke(27, 0), 2);
        JPanel lastLine = this.initializeLastLine();
        this.labelTranslation.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Container containerDialog = this.getContentPane();
        containerDialog.add((Component)this.labelTranslation, "North");
        containerDialog.add((Component)lastLine, "South");
        this.initializeTextToTranslate();
        containerDialog.add((Component)new LightScrollPane(1, 0, 1, 0, this.textToTranslate), "Center");
    }

    public final void initializeDialog(Language language) {
        this.progressBarTranslation.setValue(0);
        this.progressBarTranslation.setString("Loading...");
        this.language = language;
        this.labelTranslation.setText(String.join((CharSequence)"", "<html>", "<b>Contribute and translate parts of jSQL Injection into ", language.toString(), "</b><br>", "Help the community and translate some buttons, menus, tabs and tooltips into ", language.toString(), ", ", "then click on Send to forward your changes to the developer on Github.<br>", "<i>E.g. for French, change <b>CONTEXT_MENU_COPY = Copy</b> to <b>CONTEXT_MENU_COPY = Copier</b>, then click on Send. The list only displays what needs to be translated ", "and is updated as soon as the developer processes your request.</i>", "</html>"));
        this.labelTranslation.setIcon(language.getFlag());
        this.labelTranslation.setIconTextGap(8);
        this.setTitle("Translate to " + language);
        this.textToTranslate.setText(null);
        this.textToTranslate.setEditable(false);
        this.buttonSend.setEnabled(false);
        this.textToTranslate.setFont(new Font("Monospaced", 0, UIManager.getDefaults().getFont("TextField.font").getSize()));
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Loading text to translate into {}...", () -> language);
        new SwingWorkerGithubLocale(this).execute();
    }

    private JPanel initializeLastLine() {
        JPanel lastLine = new JPanel();
        lastLine.setLayout(new BoxLayout(lastLine, 2));
        lastLine.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonSend.setContentAreaFilled(false);
        this.buttonSend.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.buttonSend.setBackground(new Color(200, 221, 242));
        this.buttonSend.setToolTipText(String.join((CharSequence)"", "<html>", "<b>Send your translation to the developer</b><br>", "Your translation will be integrated in the next version of jSQL", "</html>"));
        this.buttonSend.addMouseListener(new FlatButtonMouseAdapter(this.buttonSend));
        this.buttonSend.addActionListener(actionEvent -> {
            if (this.textToTranslate.getText().equals(this.textBeforeChange)) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Nothing changed, translate a piece of text then click on Send");
                return;
            }
            String clientDescription = this.textToTranslate.getText().replace("\\\\", "\\\\\\\\").replaceAll("(?m)^#", "\\\\#").replace("<", "\\<");
            MediatorHelper.model().getMediatorUtils().getGitUtil().sendReport(clientDescription, GitUtil.ShowOnConsole.YES, this.language + " translation");
            this.setVisible(false);
        });
        this.setLayout(new BorderLayout());
        this.progressBarTranslation.setUI(new BasicProgressBarUI());
        this.progressBarTranslation.setOpaque(false);
        this.progressBarTranslation.setStringPainted(true);
        this.progressBarTranslation.setValue(0);
        lastLine.add(this.progressBarTranslation);
        lastLine.add(Box.createGlue());
        lastLine.add(this.buttonSend);
        return lastLine;
    }

    private void initializeTextToTranslate() {
        this.textToTranslate.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                DialogTranslate.this.textToTranslate.requestFocusInWindow();
            }
        });
        this.textToTranslate.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent arg0) {
                DialogTranslate.this.textToTranslate.getCaret().setVisible(true);
                DialogTranslate.this.textToTranslate.getCaret().setSelectionVisible(true);
            }
        });
        this.textToTranslate.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.textToTranslate.setDragEnabled(true);
        this.textToTranslate.getCaret().setBlinkRate(500);
        this.textToTranslate.setComponentPopupMenu(new JPopupMenuText(this.textToTranslate));
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getTextBeforeChange() {
        return this.textBeforeChange;
    }

    public void setTextBeforeChange(String textBeforeChange) {
        this.textBeforeChange = textBeforeChange;
    }

    public JButton getButtonSend() {
        return this.buttonSend;
    }

    public JLabel getLabelTranslation() {
        return this.labelTranslation;
    }

    public JTextArea getTextToTranslate() {
        return this.textToTranslate;
    }

    public JProgressBar getProgressBarTranslation() {
        return this.progressBarTranslation;
    }
}

