/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.manager.AbstractManagerList;
import com.jsql.view.swing.manager.util.JButtonStateful;
import com.jsql.view.swing.manager.util.StateButton;
import com.jsql.view.swing.ui.FlatButtonMouseAdapter;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManagerAdminPage
extends AbstractManagerList {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public ManagerAdminPage() {
        super("swing/list/admin-page.txt");
        this.initializeRunButton();
        this.listFile.setName("listManagerAdminPage");
        this.run.setName("runManagerAdminPage");
        this.lastLine.setLayout(new BorderLayout());
        this.lastLine.setPreferredSize(new Dimension(0, 26));
        JPanel panelRunButton = new JPanel();
        panelRunButton.setLayout(new BoxLayout(panelRunButton, 0));
        panelRunButton.add(Box.createHorizontalGlue());
        panelRunButton.add(this.loader);
        panelRunButton.add(Box.createRigidArea(new Dimension(5, 0)));
        panelRunButton.add(this.run);
        this.lastLine.add((Component)panelRunButton, "After");
        this.add((Component)this.lastLine, "South");
    }

    private void initializeRunButton() {
        this.defaultText = "ADMIN_PAGE_RUN_BUTTON_LABEL";
        this.run = new JButtonStateful(this.defaultText);
        I18nViewUtil.addComponentForKey("ADMIN_PAGE_RUN_BUTTON_LABEL", this.run);
        this.run.setToolTipText(I18nUtil.valueByKey("ADMIN_PAGE_RUN_BUTTON_TOOLTIP"));
        this.run.setContentAreaFilled(false);
        this.run.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.run.setBackground(new Color(200, 221, 242));
        this.run.addMouseListener(new FlatButtonMouseAdapter(this.run));
        this.run.addActionListener(actionEvent -> this.runSearch());
        this.loader.setVisible(false);
    }

    private void runSearch() {
        if (this.listFile.getSelectedValuesList().isEmpty()) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Select at least one admin page in the list");
            return;
        }
        Object urlAddressBar = MediatorHelper.panelAddressBar().getTextFieldAddress().getText();
        if (!((String)urlAddressBar).isEmpty() && !((String)urlAddressBar).matches("(?i)^https?://.*")) {
            if (!((String)urlAddressBar).matches("(?i)^\\w+://.*")) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, () -> I18nUtil.valueByKey("LOG_ADMIN_NO_PROTOCOL"));
                urlAddressBar = "http://" + (String)urlAddressBar;
            } else {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, () -> I18nUtil.valueByKey("LOG_ADMIN_UNKNOWN_PROTOCOL"));
                return;
            }
        }
        String urlFinal = urlAddressBar;
        new Thread(() -> this.searchAdminPages(urlFinal), "ThreadAdminPage").start();
    }

    private void searchAdminPages(String urlAddressBar) {
        if (this.run.getState() == StateButton.STARTABLE) {
            if (StringUtils.isEmpty(urlAddressBar)) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Missing URL in address bar");
            } else {
                LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Checking admin page(s)...");
                this.run.setText(I18nViewUtil.valueByKey("ADMIN_PAGE_RUN_BUTTON_STOP"));
                this.run.setState(StateButton.STOPPABLE);
                this.loader.setVisible(true);
                try {
                    MediatorHelper.model().getResourceAccess().createAdminPages(urlAddressBar, this.listFile.getSelectedValuesList().stream().map(ItemList::toString).collect(Collectors.toList()));
                }
                catch (InterruptedException e) {
                    LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        } else if (this.run.getState() == StateButton.STOPPABLE) {
            MediatorHelper.model().getResourceAccess().setSearchAdminStopped(true);
            this.run.setEnabled(false);
            this.run.setState(StateButton.STOPPING);
        }
    }
}

