/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.manager.Manager;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.tree.CellEditorNode;
import com.jsql.view.swing.tree.CellRendererNode;
import com.jsql.view.swing.tree.TreeDatabase;
import com.jsql.view.swing.tree.model.AbstractNodeModel;
import com.jsql.view.swing.tree.model.NodeModelEmpty;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManagerDatabase
extends JPanel
implements Manager {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private TreeDatabase tree;

    public ManagerDatabase() {
        super(new BorderLayout());
        this.initializeTree();
        LightScrollPane scroller = new LightScrollPane(0, 0, 0, 0, this.tree);
        this.add((Component)scroller, "Center");
    }

    private void initializeTree() {
        NodeModelEmpty nodeModelEmpty = new NodeModelEmpty(I18nViewUtil.valueByKey("DATABASE_EMPTY"));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(nodeModelEmpty);
        I18nViewUtil.addComponentForKey("DATABASE_EMPTY", nodeModelEmpty);
        this.tree = new TreeDatabase(root);
        this.tree.setName("treeDatabases");
        MediatorHelper.register(this.tree);
        this.tree.setCellRenderer(new CellRendererNode());
        this.tree.addFocusListener(this.getTreeFocusListener());
        this.tree.addMouseListener(this.getTreeMouseListener());
        this.tree.addKeyListener(this.getTreeKeyListener());
        this.tree.setCellEditor(new CellEditorNode());
        this.tree.setEditable(true);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.getModel().addTreeModelListener(new TreeModelGifListener());
        this.tree.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
    }

    private KeyAdapter getTreeKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AbstractNodeModel nodeModel;
                DefaultMutableTreeNode treeNode;
                if (e.getKeyCode() == 113 && (treeNode = (DefaultMutableTreeNode)ManagerDatabase.this.tree.getLastSelectedPathComponent()) != null && (nodeModel = (AbstractNodeModel)treeNode.getUserObject()) != null && nodeModel.getPanel() != null && !nodeModel.isRunning()) {
                    nodeModel.getPanel().getLabel().setBackground(UiUtil.COLOR_FOCUS_LOST);
                    nodeModel.getPanel().getLabel().setBorder(UiUtil.BORDER_FOCUS_LOST);
                    nodeModel.setIsEdited(true);
                }
            }
        };
    }

    private MouseAdapter getTreeMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                int selRow = ManagerDatabase.this.tree.getRowForLocation(event.getX(), event.getY());
                TreePath selPath = ManagerDatabase.this.tree.getPathForLocation(event.getX(), event.getY());
                if (selRow != -1 && event.getClickCount() == 2) {
                    try {
                        if (ManagerDatabase.this.tree.isExpanded(selPath)) {
                            ManagerDatabase.this.tree.collapsePath(selPath);
                        } else {
                            ManagerDatabase.this.tree.expandPath(selPath);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
                    }
                }
            }
        };
    }

    private FocusListener getTreeFocusListener() {
        return new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractNodeModel nodeModel;
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)ManagerDatabase.this.tree.getLastSelectedPathComponent();
                if (treeNode != null && (nodeModel = (AbstractNodeModel)treeNode.getUserObject()) != null && nodeModel.getPanel() != null) {
                    nodeModel.getPanel().getLabel().setBackground(UiUtil.COLOR_FOCUS_LOST);
                    nodeModel.getPanel().getLabel().setBorder(UiUtil.BORDER_FOCUS_LOST);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                AbstractNodeModel nodeModel;
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)ManagerDatabase.this.tree.getLastSelectedPathComponent();
                if (treeNode != null && (nodeModel = (AbstractNodeModel)treeNode.getUserObject()) != null && nodeModel.getPanel() != null) {
                    nodeModel.getPanel().getLabel().setBackground(UiUtil.COLOR_FOCUS_GAINED);
                    nodeModel.getPanel().getLabel().setBorder(UiUtil.BORDER_FOCUS_GAINED);
                }
            }
        };
    }

    public JTree getTree() {
        return this.tree;
    }

    private class TreeModelGifListener
    implements TreeModelListener {
        private TreeModelGifListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent arg0) {
            if (arg0 == null) {
                return;
            }
            ManagerDatabase.this.tree.firePropertyChange("rootVisible", !ManagerDatabase.this.tree.isRootVisible(), ManagerDatabase.this.tree.isRootVisible());
            ManagerDatabase.this.tree.treeDidChange();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent arg0) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent arg0) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent arg0) {
        }
    }
}

