/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager.util;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.bruter.HashBruter;
import com.jsql.view.swing.manager.ManagerBruteForce;
import com.jsql.view.swing.manager.util.StateButton;
import com.jsql.view.swing.util.I18nViewUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ActionBruteForce
implements ActionListener,
Runnable {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final ManagerBruteForce bruteForceManager;
    private boolean isStopped = false;

    public ActionBruteForce(ManagerBruteForce bruteForceManager) {
        this.bruteForceManager = bruteForceManager;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.bruteForceManager.getRun().getState() == StateButton.STOPPABLE) {
            this.bruteForceManager.getRun().setEnabled(false);
            this.isStopped = true;
        } else {
            if (StringUtils.isEmpty(this.bruteForceManager.getHash().getText())) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, () -> I18nUtil.valueByKey("BRUTEFORCE_EMPTY_HASH"));
                return;
            }
            if (this.isRangeNotSelected()) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, () -> I18nUtil.valueByKey("BRUTEFORCE_CHARACTER_RANGE"));
                return;
            }
            if (this.isLengthNotValid()) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, () -> I18nUtil.valueByKey("BRUTEFORCE_INCORRECT_MIN_MAX_LENGTH"));
                return;
            }
            new Thread((Runnable)this, "ThreadDisplayBruteForce").start();
        }
    }

    private boolean isLengthNotValid() {
        return Integer.parseInt(this.bruteForceManager.getMaximumLength().getValue().toString()) < Integer.parseInt(this.bruteForceManager.getMinimumLength().getValue().toString());
    }

    private boolean isRangeNotSelected() {
        return !this.bruteForceManager.getSpecialCharacters().isSelected() && !this.bruteForceManager.getUpperCaseCharacters().isSelected() && !this.bruteForceManager.getLowerCaseCharacters().isSelected() && !this.bruteForceManager.getNumericCharacters().isSelected();
    }

    @Override
    public void run() {
        this.bruteForceManager.getRun().setText(I18nViewUtil.valueByKey("BRUTEFORCE_STOP"));
        this.bruteForceManager.getRun().setState(StateButton.STOPPABLE);
        this.bruteForceManager.getLoader().setVisible(true);
        this.bruteForceManager.getResult().setText(null);
        HashBruter hashBruter = new HashBruter();
        this.initializeBruter(hashBruter);
        new Thread(hashBruter::tryBruteForce, "ThreadRunBruteForce").start();
        while (!(hashBruter.isDone() || hashBruter.isFound() || this.isStopped)) {
            hashBruter.setEndtime(System.nanoTime());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
            int selectionStart = this.bruteForceManager.getResult().getSelectionStart();
            int selectionEnd = this.bruteForceManager.getResult().getSelectionEnd();
            this.updateResult(hashBruter);
            this.bruteForceManager.getResult().setSelectionStart(selectionStart);
            this.bruteForceManager.getResult().setSelectionEnd(selectionEnd);
            if (!this.isStopped) continue;
            hashBruter.setIsDone(true);
            hashBruter.setFound(true);
            break;
        }
        this.displayResult(hashBruter);
        this.isStopped = false;
        this.bruteForceManager.getLoader().setVisible(false);
        this.bruteForceManager.getRun().setText(I18nViewUtil.valueByKey("BRUTEFORCE_START"));
        this.bruteForceManager.getRun().setEnabled(true);
        this.bruteForceManager.getRun().setState(StateButton.STARTABLE);
    }

    private void updateResult(HashBruter hashBruter) {
        this.bruteForceManager.getResult().setText(I18nUtil.valueByKey("BRUTEFORCE_CURRENT_STRING") + ": " + hashBruter.getPassword());
        this.append(this.bruteForceManager.getResult(), I18nUtil.valueByKey("BRUTEFORCE_CURRENT_HASH") + ": " + hashBruter.getGeneratedHash() + "\n");
        this.append(this.bruteForceManager.getResult(), I18nUtil.valueByKey("BRUTEFORCE_POSSIBILITIES") + ": " + hashBruter.getNumberOfPossibilities());
        this.append(this.bruteForceManager.getResult(), I18nUtil.valueByKey("BRUTEFORCE_CHECKED_HASHES") + ": " + hashBruter.getCounter());
        this.append(this.bruteForceManager.getResult(), I18nUtil.valueByKey("BRUTEFORCE_ESTIMATED") + ": " + hashBruter.getRemainder());
        this.append(this.bruteForceManager.getResult(), I18nUtil.valueByKey("BRUTEFORCE_PERSECOND") + ": " + hashBruter.getPerSecond() + "\n");
        this.append(this.bruteForceManager.getResult(), hashBruter.calculateTimeElapsed());
        if (hashBruter.getPerSecond() != 0) {
            float remainingDuration = Float.parseFloat(Long.toString(hashBruter.getRemainder())) / (float)hashBruter.getPerSecond();
            this.append(this.bruteForceManager.getResult(), I18nUtil.valueByKey("BRUTEFORCE_TRAVERSING_REMAINING") + ": " + Math.round(Math.floor(remainingDuration / 60.0f / 60.0f / 24.0f)) + I18nUtil.valueByKey("BRUTEFORCE_DAYS") + " " + Math.round(Math.floor(remainingDuration / 60.0f / 60.0f % 24.0f)) + I18nUtil.valueByKey("BRUTEFORCE_HOURS") + " " + Math.round(Math.floor(remainingDuration / 60.0f % 60.0f)) + I18nUtil.valueByKey("BRUTEFORCE_MINUTES") + " " + Math.round(remainingDuration % 60.0f) + I18nUtil.valueByKey("BRUTEFORCE_SECONDS"));
        }
        this.append(this.bruteForceManager.getResult(), String.format("%s: %s%%", I18nUtil.valueByKey("BRUTEFORCE_PERCENT_DONE"), Float.valueOf(100.0f * (float)hashBruter.getCounter() / (float)hashBruter.getNumberOfPossibilities())));
    }

    private void initializeBruter(HashBruter hashBruter) {
        hashBruter.setMinLength(Integer.parseInt(this.bruteForceManager.getMinimumLength().getValue().toString()));
        hashBruter.setMaxLength(Integer.parseInt(this.bruteForceManager.getMaximumLength().getValue().toString()));
        if (this.bruteForceManager.getSpecialCharacters().isSelected()) {
            hashBruter.addSpecialCharacters();
        }
        if (this.bruteForceManager.getUpperCaseCharacters().isSelected()) {
            hashBruter.addUpperCaseLetters();
        }
        if (this.bruteForceManager.getLowerCaseCharacters().isSelected()) {
            hashBruter.addLowerCaseLetters();
        }
        if (this.bruteForceManager.getNumericCharacters().isSelected()) {
            hashBruter.addDigits();
        }
        if (StringUtils.isNotEmpty(this.bruteForceManager.getExclude().getText())) {
            hashBruter.excludeChars(this.bruteForceManager.getExclude().getText());
        }
        hashBruter.setType((String)this.bruteForceManager.getHashTypes().getSelectedItem());
        hashBruter.setHash(this.bruteForceManager.getHash().getText().toUpperCase(Locale.ROOT).replaceAll("[^a-zA-Z0-9]", "").trim());
    }

    private void displayResult(HashBruter hashBruter) {
        if (this.isStopped) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, () -> I18nUtil.valueByKey("BRUTEFORCE_ABORTED"));
        } else if (hashBruter.isFound()) {
            this.append(this.bruteForceManager.getResult(), String.format("%n%s:%n%s => %s", I18nUtil.valueByKey("BRUTEFORCE_FOUND_HASH"), hashBruter.getGeneratedHash(), hashBruter.getPassword()));
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> I18nUtil.valueByKey("BRUTEFORCE_FOUND_HASH");
            supplierArray[1] = hashBruter::getGeneratedHash;
            supplierArray[2] = hashBruter::getPassword;
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{}: {} => {}", supplierArray);
        } else if (hashBruter.isDone()) {
            this.append(this.bruteForceManager.getResult(), "\n" + I18nUtil.valueByKey("BRUTEFORCE_HASH_NOT_FOUND"));
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, () -> I18nUtil.valueByKey("BRUTEFORCE_HASH_NOT_FOUND"));
        }
    }

    public void append(JTextPane textPane, String text) {
        try {
            textPane.getDocument().insertString(textPane.getDocument().getLength(), (textPane.getDocument().getLength() == 0 ? "" : "\n") + text, null);
        }
        catch (BadLocationException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

