/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager.util;

import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.util.bruter.ActionCoder;
import com.jsql.view.swing.manager.ManagerCoder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CoderListener
implements ActionListener {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final ManagerCoder coderManager;

    public CoderListener(ManagerCoder coderManager) {
        this.coderManager = coderManager;
    }

    public void actionPerformed() {
        this.transform(this.coderManager.getMenuMethod().getText());
    }

    public void actionPerformed(String nameMethod) {
        this.transform(nameMethod);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.transform(this.coderManager.getMenuMethod().getText());
    }

    private void transform(String labelMethodMenu) {
        String result;
        String nameMethod = labelMethodMenu.replace("Hash to ", "");
        String textInput = this.coderManager.getTextInput().getText();
        try {
            if (StringUtils.isEmpty(textInput) && !Arrays.asList("Md2", "Md4", "Md5", "Sha-1", "Sha-256", "Sha-384", "Sha-512", "Mysql").contains(nameMethod)) {
                result = "<span style=\"color:red;\">Empty string to convert</span>";
            } else {
                result = ActionCoder.forName(nameMethod).orElseThrow(() -> new NoSuchElementException("Unsupported encoding or decoding method")).run(textInput);
                result = StringUtil.fromHtml(result);
            }
        }
        catch (IOException | IllegalArgumentException | NoSuchAlgorithmException | DecoderException e) {
            result = String.format("<span style=\"color:red;\">Decoding failed: %s</span>", e.getMessage());
            LOGGER.log(LogLevelUtil.IGNORE, e);
        }
        this.coderManager.getResult().setText(String.format("<html><span style=\"font-family:'%s'\">%s</span></html>", "Ubuntu Mono", result));
    }
}

