/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel.address;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.panel.PanelAddressBar;
import com.jsql.view.swing.panel.util.RadioMenuItemIconCustom;
import com.jsql.view.swing.text.JPopupTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicRadioButtonMenuItemUI;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RequestPanel
extends JPanel {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String typeRequest = "GET";

    public RequestPanel(PanelAddressBar panelAddressBar) {
        this.setLayout(new BoxLayout(this, 2));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 16));
        this.setBorder(null);
        BasicArrowButton buttonRequestMethod = new BasicArrowButton(5);
        buttonRequestMethod.setBorderPainted(false);
        buttonRequestMethod.setOpaque(false);
        this.add(buttonRequestMethod);
        this.add(panelAddressBar.getRadioRequest());
        final JPopupMenu popup = new JPopupMenu();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (String protocol : new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"}) {
            JRadioButtonMenuItem newMenuItem = new JRadioButtonMenuItem(protocol, "GET".equals(protocol));
            newMenuItem.addActionListener(actionEvent -> {
                this.typeRequest = newMenuItem.getText();
                panelAddressBar.getRadioRequest().setText(this.typeRequest);
            });
            popup.add(newMenuItem);
            buttonGroup.add(newMenuItem);
        }
        for (AbstractButton radioButton : Collections.list(buttonGroup.getElements())) {
            radioButton.setUI(new BasicRadioButtonMenuItemUI(){

                @Override
                protected void doClick(MenuSelectionManager msm) {
                    this.menuItem.doClick(0);
                }
            });
        }
        JPanel panelCustomMethod = new JPanel(new BorderLayout());
        JTextField inputCustomMethod = (JTextField)new JPopupTextField("CUSTOM").getProxy();
        final JRadioButton radioCustomMethod = new JRadioButton();
        radioCustomMethod.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        radioCustomMethod.setIcon(new RadioMenuItemIconCustom());
        buttonGroup.add(radioCustomMethod);
        radioCustomMethod.addActionListener(actionEvent -> {
            if (StringUtils.isNotEmpty(inputCustomMethod.getText())) {
                this.typeRequest = inputCustomMethod.getText();
                panelAddressBar.getRadioRequest().setText(this.typeRequest);
            } else {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Define label of Custom request method");
            }
        });
        panelCustomMethod.add((Component)radioCustomMethod, "Before");
        panelCustomMethod.add((Component)inputCustomMethod, "Center");
        popup.insert(panelCustomMethod, popup.getComponentCount());
        buttonRequestMethod.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                popup.applyComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault()));
                if (ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault()))) {
                    radioCustomMethod.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
                } else {
                    radioCustomMethod.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
                }
                popup.show(e.getComponent(), ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault())) ? e.getComponent().getX() - e.getComponent().getWidth() - popup.getWidth() : e.getComponent().getX(), e.getComponent().getY() + e.getComponent().getWidth());
                popup.setLocation(ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getLocaleDefault())) ? e.getComponent().getLocationOnScreen().x + e.getComponent().getWidth() - popup.getWidth() : e.getComponent().getLocationOnScreen().x, e.getComponent().getLocationOnScreen().y + e.getComponent().getWidth());
            }
        });
    }

    public String getTypeRequest() {
        return this.typeRequest;
    }

    public void setTypeRequest(String typeRequest) {
        this.typeRequest = typeRequest;
    }
}

