/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.shadow;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ShadowPopupBorder
extends AbstractBorder {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final int SHADOW_SIZE = 5;
    private static final ShadowPopupBorder instance = new ShadowPopupBorder();
    private static final Image shadow = UiUtil.IMG_SHADOW;

    public static ShadowPopupBorder getInstance() {
        return instance;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        try {
            Image vShadowBg;
            JComponent popup = (JComponent)c;
            Image hShadowBg = (Image)popup.getClientProperty("jgoodies.hShadowBg");
            if (hShadowBg != null) {
                g.drawImage(hShadowBg, x, y + height - 5, c);
            }
            if ((vShadowBg = (Image)popup.getClientProperty("jgoodies.vShadowBg")) != null) {
                g.drawImage(vShadowBg, x + width - 5, y, c);
            }
            g.drawImage(shadow, x + 5, y + height - 5, x + 10, y + height, 0, 6, 5, 11, null, c);
            g.drawImage(shadow, x + 10, y + height - 5, x + width - 5, y + height, 5, 6, 6, 11, null, c);
            g.drawImage(shadow, x + width - 5, y + 5, x + width, y + 10, 6, 0, 11, 5, null, c);
            g.drawImage(shadow, x + width - 5, y + 10, x + width, y + height - 5, 6, 5, 11, 6, null, c);
            g.drawImage(shadow, x + width - 5, y + height - 5, x + width, y + height, 6, 6, 11, 11, null, c);
        }
        catch (ClassCastException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, 5, 5);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 0;
        insets.left = 0;
        insets.bottom = 5;
        insets.right = 5;
        return insets;
    }
}

