/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.splitpane;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JSplitPaneWithZeroSizeDivider
extends JSplitPane {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private int dividerDragSize = 9;
    private int dividerDragOffset = 0;

    public JSplitPaneWithZeroSizeDivider(int orientation) {
        super(orientation, true);
    }

    public void disableDragSize() {
        this.dividerDragSize = 0;
    }

    public void enableDragSize() {
        this.dividerDragSize = 9;
    }

    public int getDividerDragSize() {
        return this.dividerDragSize;
    }

    public void setDividerDragSize(int dividerDragSize) {
        this.dividerDragSize = dividerDragSize;
        this.revalidate();
    }

    public int getDividerDragOffset() {
        return this.dividerDragOffset;
    }

    public void setDividerDragOffset(int dividerDragOffset) {
        this.dividerDragOffset = dividerDragOffset;
        this.revalidate();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        Rectangle bounds = divider.getBounds();
        if (this.orientation == 1) {
            bounds.x -= this.dividerDragOffset;
            bounds.width = this.dividerDragSize;
        } else {
            bounds.y -= this.dividerDragOffset;
            bounds.height = this.dividerDragSize;
        }
        divider.setBounds(bounds);
    }

    @Override
    public void updateUI() {
        this.setUI(new SplitPaneWithZeroSizeDividerUI());
        this.revalidate();
    }

    private class SplitPaneWithZeroSizeDividerUI
    extends BasicSplitPaneUI {
        private SplitPaneWithZeroSizeDividerUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new ZeroSizeDivider(this);
        }
    }

    private class ZeroSizeDivider
    extends BasicSplitPaneDivider {
        public ZeroSizeDivider(BasicSplitPaneUI ui) {
            super(ui);
            super.setBorder(null);
            this.setBackground(UiUtil.COLOR_COMPONENT_BORDER);
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            if (this.orientation == 1) {
                try {
                    g.drawLine(JSplitPaneWithZeroSizeDivider.this.dividerDragOffset, 0, JSplitPaneWithZeroSizeDivider.this.dividerDragOffset, this.getHeight() - 1);
                }
                catch (ClassCastException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
                }
            } else {
                g.drawLine(0, JSplitPaneWithZeroSizeDivider.this.dividerDragOffset, this.getWidth() - 1, JSplitPaneWithZeroSizeDivider.this.dividerDragOffset);
            }
        }

        @Override
        protected void dragDividerTo(int location) {
            super.dragDividerTo(location + JSplitPaneWithZeroSizeDivider.this.dividerDragOffset);
        }

        @Override
        protected void finishDraggingTo(int location) {
            super.finishDraggingTo(location + JSplitPaneWithZeroSizeDivider.this.dividerDragOffset);
        }
    }
}

