/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.table;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.popupmenu.JPopupMenuTable;
import com.jsql.view.swing.scrollpane.JScrollIndicator;
import com.jsql.view.swing.tab.ButtonClose;
import com.jsql.view.swing.table.ActionCloseSearch;
import com.jsql.view.swing.table.ActionShowSearch;
import com.jsql.view.swing.table.AdjusterTableColumn;
import com.jsql.view.swing.table.ComparatorColumn;
import com.jsql.view.swing.table.FixedColumnTable;
import com.jsql.view.swing.text.JTextFieldPlaceholder;
import com.jsql.view.swing.util.UiStringUtil;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PanelTable
extends JPanel {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final JTable tableValues;

    public PanelTable(String[][] data, String[] columnNames) {
        super(new BorderLayout());
        this.tableValues = new JTable(data, columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableValues.setAutoResizeMode(0);
        this.tableValues.setSelectionMode(2);
        this.tableValues.setColumnSelectionAllowed(true);
        this.tableValues.setRowHeight(20);
        this.tableValues.setRowSelectionAllowed(true);
        this.tableValues.setCellSelectionEnabled(true);
        this.tableValues.setGridColor(Color.LIGHT_GRAY);
        this.initializeRenderer();
        this.tableValues.getTableHeader().setReorderingAllowed(false);
        this.initializeMouseEvent();
        this.initializeTabShortcut();
        AdjusterTableColumn columnAdjuster = new AdjusterTableColumn(this.tableValues);
        columnAdjuster.adjustColumns();
        TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(this.tableValues.getModel());
        this.tableValues.setRowSorter(rowSorter);
        this.initializeTableScroller();
        this.initializePanelSearch(rowSorter);
        ComparatorColumn comparatorNumeric = new ComparatorColumn();
        for (int i = 0; i < this.tableValues.getColumnCount(); ++i) {
            rowSorter.setComparator(i, comparatorNumeric);
        }
    }

    private void initializeMouseEvent() {
        this.tableValues.setDragEnabled(true);
        this.tableValues.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PanelTable.this.tableValues.requestFocusInWindow();
                if (SwingUtilities.isRightMouseButton(e)) {
                    Point p = e.getPoint();
                    int rowNumber = PanelTable.this.tableValues.rowAtPoint(p);
                    int colNumber = PanelTable.this.tableValues.columnAtPoint(p);
                    DefaultListSelectionModel modelRow = (DefaultListSelectionModel)PanelTable.this.tableValues.getSelectionModel();
                    DefaultListSelectionModel modelColumn = (DefaultListSelectionModel)PanelTable.this.tableValues.getColumnModel().getSelectionModel();
                    modelRow.moveLeadSelectionIndex(rowNumber);
                    modelColumn.moveLeadSelectionIndex(colNumber);
                }
            }
        });
    }

    private void initializeRenderer() {
        TableCellRenderer cellRendererHeader = this.tableValues.getTableHeader().getDefaultRenderer();
        DefaultTableCellRenderer cellRendererDefault = new DefaultTableCellRenderer();
        this.tableValues.getTableHeader().setDefaultRenderer((table, value, isSelected, hasFocus, row, column) -> {
            JLabel label = (JLabel)cellRendererHeader.getTableCellRendererComponent(table, UiStringUtil.detectUtf8HtmlNoWrap(" " + value + " "), isSelected, hasFocus, row, column);
            label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            return label;
        });
        this.tableValues.setDefaultRenderer(this.tableValues.getColumnClass(2), (table, value, isSelected, hasFocus, row, column) -> {
            String cellValue = value != null ? value.toString() : "";
            try {
                return cellRendererDefault.getTableCellRendererComponent(table, UiStringUtil.detectUtf8HtmlNoWrap(cellValue), isSelected, hasFocus, row, column);
            }
            catch (NullPointerException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
                return null;
            }
        });
    }

    private void initializeTableScroller() {
        JScrollIndicator scroller = new JScrollIndicator(this.tableValues);
        scroller.getScrollPane().setBorder(BorderFactory.createEmptyBorder(0, 0, -1, -1));
        scroller.getScrollPane().setViewportBorder(BorderFactory.createEmptyBorder(0, 0, -1, -1));
        AdjustmentListener singleItemScroll = adjustmentEvent -> {
            if (adjustmentEvent.getAdjustmentType() == 5) {
                adjustmentEvent.getAdjustable().setBlockIncrement(100);
                adjustmentEvent.getAdjustable().setUnitIncrement(100);
            }
        };
        scroller.getScrollPane().getVerticalScrollBar().addAdjustmentListener(singleItemScroll);
        scroller.getScrollPane().getHorizontalScrollBar().addAdjustmentListener(singleItemScroll);
        FixedColumnTable tableFixedColumn = new FixedColumnTable();
        tableFixedColumn.fixColumnSize(2, scroller.getScrollPane());
        this.add((Component)scroller, "Center");
    }

    private void initializePanelSearch(final TableRowSorter<TableModel> rowSorter) {
        JPanel panelSearch = new JPanel(new BorderLayout());
        panelSearch.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        final JTextFieldPlaceholder textFilter = new JTextFieldPlaceholder("Find in table");
        panelSearch.add((Component)textFilter, "Center");
        ActionShowSearch actionShowSearchTable = new ActionShowSearch(panelSearch, textFilter);
        this.tableValues.getActionMap().put("search", actionShowSearchTable);
        this.tableValues.getInputMap().put(KeyStroke.getKeyStroke(70, 128), "search");
        ActionCloseSearch actionCloseSearch = new ActionCloseSearch(textFilter, panelSearch, this);
        textFilter.getActionMap().put("close", actionCloseSearch);
        textFilter.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "close");
        textFilter.getDocument().addDocumentListener(new DocumentListener(){

            private void insertUpdateFixed() {
                String text = textFilter.getText();
                if (text.trim().length() == 0) {
                    rowSorter.setRowFilter(null);
                } else {
                    rowSorter.setRowFilter(RowFilter.regexFilter("(?i)" + Pattern.quote(text), new int[0]));
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.insertUpdateFixed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.insertUpdateFixed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        this.tableValues.setComponentPopupMenu(new JPopupMenuTable(this.tableValues, actionShowSearchTable));
        ButtonClose buttonCloseSearch = new ButtonClose();
        buttonCloseSearch.addActionListener(actionCloseSearch);
        panelSearch.add((Component)buttonCloseSearch, "East");
        this.add((Component)panelSearch, "South");
        panelSearch.setVisible(false);
    }

    private void initializeTabShortcut() {
        this.tableValues.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), null);
        this.tableValues.getInputMap(1).put(KeyStroke.getKeyStroke(9, 64), null);
        HashSet<AWTKeyStroke> forward = new HashSet<AWTKeyStroke>(this.tableValues.getFocusTraversalKeys(0));
        forward.add(KeyStroke.getKeyStroke("TAB"));
        this.tableValues.setFocusTraversalKeys(0, forward);
        HashSet<AWTKeyStroke> backward = new HashSet<AWTKeyStroke>(this.tableValues.getFocusTraversalKeys(1));
        backward.add(KeyStroke.getKeyStroke("shift TAB"));
        this.tableValues.setFocusTraversalKeys(1, backward);
    }

    public void selectTable() {
        this.tableValues.selectAll();
    }

    public void copyTable() {
        ActionEvent nev = new ActionEvent(this.tableValues, 1001, "copy");
        this.tableValues.getActionMap().get(nev.getActionCommand()).actionPerformed(nev);
    }

    public JTable getTableValues() {
        return this.tableValues;
    }
}

